/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Set;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.parser.interfaces.resolver.ClassResolverExtension;
import tools.mdsd.jamopp.parser.interfaces.resolver.MethodCompleter;
import tools.mdsd.jamopp.parser.interfaces.resolver.Resolver;
import tools.mdsd.jamopp.parser.interfaces.resolver.ResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class MethodCompleterImpl
implements MethodCompleter {
    private final boolean extractAdditionalInfosFromTypeBindings;
    private final Set<IMethodBinding> methodBindings;
    private final ResolverWithCache<AnonymousClass, ITypeBinding> anonymousClassResolver;
    private final ToStringConverter<IMethodBinding> toMethodNameConverter;
    private final Resolver<Classifier, ITypeBinding> classifierResolver;
    private final ToStringConverter<ITypeBinding> toTypeNameConverter;
    private final ClassResolverExtension classResolverExtensionImpl;

    @Inject
    public MethodCompleterImpl(Set<IMethodBinding> methodBindings, @Named(value="extractAdditionalInfosFromTypeBindings") boolean extractAdditionalInfosFromBindings, ResolverWithCache<AnonymousClass, ITypeBinding> anonymousClassResolver, @Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverter, ToStringConverter<IMethodBinding> toMethodNameConverter, Resolver<Classifier, ITypeBinding> classifierResolver, ClassResolverExtension classResolverExtensionImpl) {
        this.anonymousClassResolver = anonymousClassResolver;
        this.methodBindings = methodBindings;
        this.extractAdditionalInfosFromTypeBindings = extractAdditionalInfosFromBindings;
        this.toMethodNameConverter = toMethodNameConverter;
        this.classifierResolver = classifierResolver;
        this.toTypeNameConverter = toTypeNameConverter;
        this.classResolverExtensionImpl = classResolverExtensionImpl;
    }

    @Override
    public void completeMethod(String methodName, Member method) {
        if (method.eContainer() == null) {
            IMethodBinding methBind = this.methodBindings.stream().filter(meth -> methodName.equals(this.toMethodNameConverter.convert((IMethodBinding)meth))).findFirst().orElse(null);
            if (methBind != null) {
                this.handleEmptyMehodBinding(method, methBind);
            } else {
                this.classResolverExtensionImpl.addToSyntheticClass(method);
            }
        }
    }

    private void handleEmptyMehodBinding(Member method, IMethodBinding methBind) {
        Classifier cla = this.classifierResolver.getByBinding(methBind.getDeclaringClass());
        if (cla == null) {
            String typeName = this.toTypeNameConverter.convert(methBind.getDeclaringClass());
            if (this.anonymousClassResolver.containsKey(typeName)) {
                AnonymousClass anonClass = this.anonymousClassResolver.get(typeName);
                if (!anonClass.getMembers().contains((Object)method)) {
                    anonClass.getMembers().add((Object)method);
                }
            } else {
                this.classResolverExtensionImpl.addToSyntheticClass(method);
            }
        } else if (!this.extractAdditionalInfosFromTypeBindings && cla instanceof ConcreteClassifier typeName && !classifier.getMembers().contains((Object)method)) {
            classifier.getMembers().add((Object)method);
        }
    }
}

