/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.IModuleBinding;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.containers.ContainersFactory;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;

public class ModuleResolver
extends AbstractResolverWithCache<Module, IModuleBinding> {
    private final Set<IModuleBinding> moduleBindings;
    private final ContainersFactory containersFactory;

    @Inject
    public ModuleResolver(Map<String, Module> bindings, Set<IModuleBinding> moduleBindings, ContainersFactory containersFactory) {
        super(bindings);
        this.moduleBindings = moduleBindings;
        this.containersFactory = containersFactory;
    }

    @Override
    public Module getByBinding(IModuleBinding binding) {
        this.moduleBindings.add(binding);
        return this.getByName(binding.getName());
    }

    @Override
    public Module getByName(String name) {
        Module module;
        if (this.containsKey(name)) {
            module = (Module)this.get(name);
        } else {
            Module result = JavaClasspath.get().getModule(name);
            if (result == null) {
                result = this.containersFactory.createModule();
            }
            this.putBinding(name, result);
            module = result;
        }
        return module;
    }
}

