/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.parameters.ParametersFactory;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ConverterWithBoolean;

public class OrdinaryParameterResolver
extends AbstractResolverWithCache<OrdinaryParameter, IVariableBinding> {
    private final ParametersFactory parametersFactory;
    private final Set<IVariableBinding> variableBindings;
    private final ConverterWithBoolean<IVariableBinding> toParameterNameConverter;

    @Inject
    public OrdinaryParameterResolver(Map<String, OrdinaryParameter> bindings, ParametersFactory parametersFactory, Set<IVariableBinding> variableBindings, ConverterWithBoolean<IVariableBinding> toParameterNameConverter) {
        super(bindings);
        this.parametersFactory = parametersFactory;
        this.variableBindings = variableBindings;
        this.toParameterNameConverter = toParameterNameConverter;
    }

    @Override
    public OrdinaryParameter getByBinding(IVariableBinding binding) {
        this.variableBindings.add(binding);
        return this.getByName(this.toParameterNameConverter.convertToParameterName(binding, true));
    }

    @Override
    public OrdinaryParameter getByName(String name) {
        OrdinaryParameter ordinaryParameter;
        if (this.containsKey(name)) {
            ordinaryParameter = (OrdinaryParameter)this.get(name);
        } else {
            OrdinaryParameter result = this.parametersFactory.createOrdinaryParameter();
            this.putBinding(name, result);
            ordinaryParameter = result;
        }
        return ordinaryParameter;
    }
}

