/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.IPackageBinding;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.containers.ContainersFactory;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;

public class PackageResolver
extends AbstractResolverWithCache<Package, IPackageBinding> {
    private final Set<IPackageBinding> packageBindings;
    private final ContainersFactory containersFactory;

    @Inject
    public PackageResolver(Map<String, Package> bindings, Set<IPackageBinding> packageBindings, ContainersFactory containersFactory) {
        super(bindings);
        this.packageBindings = packageBindings;
        this.containersFactory = containersFactory;
    }

    @Override
    public Package getByBinding(IPackageBinding binding) {
        this.packageBindings.add(binding);
        return this.getByName(binding.getName());
    }

    @Override
    public Package getByName(String name) {
        Package resultPackage;
        if (this.containsKey(name)) {
            resultPackage = (Package)this.get(name);
        } else {
            Package result = JavaClasspath.get().getPackage(name);
            if (result == null) {
                result = this.containersFactory.createPackage();
            }
            this.putBinding(name, result);
            resultPackage = result;
        }
        return resultPackage;
    }
}

