/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.ContainersFactory;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToConcreteClassifierConverterWithExtraInfo;
import tools.mdsd.jamopp.parser.interfaces.resolver.PureTypeBindingsConverter;
import tools.mdsd.jamopp.parser.interfaces.resolver.Resolver;
import tools.mdsd.jamopp.parser.interfaces.resolver.ResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class PureTypeBindingsConverterImpl
implements PureTypeBindingsConverter {
    private final boolean extractAdditionalInfosFromTypeBindings;
    private final ContainersFactory containersFactory;
    private final Provider<ToConcreteClassifierConverterWithExtraInfo> utilBindingInfoToConcreteClassifierConverter;
    private final Provider<Converter<IPackageBinding, Package>> bindingToPackageConverter;
    private final Provider<Converter<IModuleBinding, Module>> bindingToModuleConverter;
    private final Set<IModuleBinding> moduleBindings;
    private final Set<IPackageBinding> packageBindings;
    private final Set<ITypeBinding> typeBindings;
    private final Set<EObject> objVisited;
    private final ResolverWithCache<Module, IModuleBinding> moduleResolver;
    private final ResolverWithCache<Package, IPackageBinding> packageResolver;
    private final ResolverWithCache<Annotation, ITypeBinding> annotationResolver;
    private final ResolverWithCache<Enumeration, ITypeBinding> enumerationResolver;
    private final ResolverWithCache<Interface, ITypeBinding> interfaceResolver;
    private final ResolverWithCache<Class, ITypeBinding> classResolver;
    private final Resolver<Classifier, ITypeBinding> classifierResolver;
    private final ToStringConverter<ITypeBinding> toTypeNameConverter;

    @Inject
    public PureTypeBindingsConverterImpl(Provider<ToConcreteClassifierConverterWithExtraInfo> utilBindingInfoToConcreteClassifierConverter, ResolverWithCache<Package, IPackageBinding> packageResolver, ResolverWithCache<Module, IModuleBinding> moduleResolver, ResolverWithCache<Interface, ITypeBinding> interfaceResolver, @Named(value="extractAdditionalInfosFromTypeBindings") boolean extractAdditionalInfosFromTypeBindings, ResolverWithCache<Enumeration, ITypeBinding> enumerationResolver, ContainersFactory containersFactory, ResolverWithCache<Class, ITypeBinding> classResolver, Provider<Converter<IPackageBinding, Package>> bindingToPackageConverter, Provider<Converter<IModuleBinding, Module>> bindingToModuleConverter, ResolverWithCache<Annotation, ITypeBinding> annotationResolver, Set<ITypeBinding> typeBindings, Set<IPackageBinding> packageBindings, Set<EObject> objVisited, Set<IModuleBinding> moduleBindings, @Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverter, Resolver<Classifier, ITypeBinding> classifierResolver) {
        this.extractAdditionalInfosFromTypeBindings = extractAdditionalInfosFromTypeBindings;
        this.containersFactory = containersFactory;
        this.utilBindingInfoToConcreteClassifierConverter = utilBindingInfoToConcreteClassifierConverter;
        this.bindingToPackageConverter = bindingToPackageConverter;
        this.bindingToModuleConverter = bindingToModuleConverter;
        this.moduleBindings = moduleBindings;
        this.packageBindings = packageBindings;
        this.typeBindings = typeBindings;
        this.objVisited = objVisited;
        this.moduleResolver = moduleResolver;
        this.packageResolver = packageResolver;
        this.annotationResolver = annotationResolver;
        this.enumerationResolver = enumerationResolver;
        this.interfaceResolver = interfaceResolver;
        this.classResolver = classResolver;
        this.classifierResolver = classifierResolver;
        this.toTypeNameConverter = toTypeNameConverter;
    }

    @Override
    public void convertPureTypeBindings(ResourceSet resourceSet) {
        int oldSize;
        int newSize = this.annotationResolver.bindingsSize() + this.enumerationResolver.bindingsSize() + this.interfaceResolver.bindingsSize() + this.classResolver.bindingsSize() + this.moduleResolver.bindingsSize() + this.packageResolver.bindingsSize();
        do {
            oldSize = newSize;
            this.annotationResolver.forEachBindingOnCopy((t, u) -> this.convertPureTypeBinding((String)t, (ConcreteClassifier)u, resourceSet));
            this.enumerationResolver.forEachBindingOnCopy((t, u) -> this.convertPureTypeBinding((String)t, (ConcreteClassifier)u, resourceSet));
            this.interfaceResolver.forEachBindingOnCopy((t, u) -> this.convertPureTypeBinding((String)t, (ConcreteClassifier)u, resourceSet));
            this.classResolver.forEachBindingOnCopy((t, u) -> this.convertPureTypeBinding((String)t, (ConcreteClassifier)u, resourceSet));
            this.packageResolver.forEachBindingOnCopy((t, u) -> this.convertPurePackageBinding((String)t, (Package)u, resourceSet));
            this.moduleResolver.forEachBindingOnCopy((t, u) -> this.convertPureModuleBinding((String)t, (Module)u, resourceSet));
        } while (oldSize < (newSize = this.annotationResolver.bindingsSize() + this.enumerationResolver.bindingsSize() + this.interfaceResolver.bindingsSize() + this.classResolver.bindingsSize() + this.moduleResolver.bindingsSize() + this.packageResolver.bindingsSize()));
    }

    private void convertPureTypeBinding(String typeName, ConcreteClassifier classifier, ResourceSet resourceSet) {
        if (!this.objVisited.contains(classifier)) {
            this.objVisited.add((EObject)classifier);
            ConcreteClassifier potClass = JavaClasspath.get().getConcreteClassifier(typeName);
            if (!Objects.equals(potClass, classifier)) {
                this.convert(typeName, classifier, resourceSet);
            }
        }
    }

    private void convert(String typeName, ConcreteClassifier classifier, ResourceSet resourceSet) {
        ITypeBinding typeBind = this.typeBindings.stream().filter(type -> type != null && typeName.equals(this.toTypeNameConverter.convert((ITypeBinding)type))).findFirst().orElse(null);
        if (typeBind == null) {
            classifier.setPackage((Package)this.packageResolver.getByName(""));
            if (classifier.eContainer() != null) {
                return;
            }
        } else if (typeBind.isTopLevel()) {
            this.handleTopLevel(typeBind);
        } else if (typeBind.isNested()) {
            this.handleNested(classifier, resourceSet, typeBind);
        } else if (typeBind.isArray()) {
            this.handleArray(typeName, resourceSet, typeBind);
        }
        if (classifier.eContainer() == null) {
            this.handleNullContainer(typeName, classifier, resourceSet);
        }
    }

    private void handleNullContainer(String typeName, ConcreteClassifier classifier, ResourceSet resourceSet) {
        CompilationUnit compulationUnit = this.containersFactory.createCompilationUnit();
        compulationUnit.setName("");
        compulationUnit.getClassifiers().add((Object)classifier);
        String[] namespaces = typeName.strip().split("\\.");
        classifier.setName(namespaces[namespaces.length - 1]);
        int index = 0;
        while (index < namespaces.length - 1) {
            compulationUnit.getNamespaces().add((Object)namespaces[index]);
            ++index;
        }
        Resource newResource = resourceSet.createResource(URI.createHierarchicalURI((String)"empty", (String)"JaMoPP-CompilationUnit", null, (String[])new String[]{String.valueOf(typeName) + ".java"}, null, null));
        newResource.getContents().add((Object)compulationUnit);
    }

    private void handleTopLevel(ITypeBinding typeBind) {
        ((ToConcreteClassifierConverterWithExtraInfo)this.utilBindingInfoToConcreteClassifierConverter.get()).convert(typeBind, this.extractAdditionalInfosFromTypeBindings);
    }

    private void handleNested(ConcreteClassifier classifier, ResourceSet resourceSet, ITypeBinding typeBind) {
        ConcreteClassifier parentClassifier = (ConcreteClassifier)this.classifierResolver.getByBinding(typeBind.getDeclaringClass());
        this.convertPureTypeBinding(this.toTypeNameConverter.convert(typeBind.getDeclaringClass()), parentClassifier, resourceSet);
        classifier.setPackage((Package)this.packageResolver.getByBinding(typeBind.getPackage()));
    }

    private void handleArray(String typeName, ResourceSet resourceSet, ITypeBinding typeBind) {
        ITypeBinding elementType = typeBind.getElementType();
        if (!elementType.isPrimitive() && !elementType.isTypeVariable()) {
            this.convertPureTypeBinding(typeName, (ConcreteClassifier)this.classifierResolver.getByBinding(elementType), resourceSet);
        }
    }

    private void convertPurePackageBinding(String packageName, Package pack, ResourceSet resourceSet) {
        if (!this.objVisited.contains(pack)) {
            this.objVisited.add((EObject)pack);
            Package potPack = JavaClasspath.get().getPackage(packageName);
            if (!Objects.equals(potPack, pack)) {
                IPackageBinding binding = this.packageBindings.stream().filter(b -> packageName.equals(b.getName())).findFirst().orElse(null);
                if (binding == null) {
                    pack.setName("");
                    pack.setModule((Module)this.moduleResolver.getByName(""));
                } else {
                    ((Converter)this.bindingToPackageConverter.get()).convert(binding);
                }
                if (pack.eResource() != null) {
                    return;
                }
                Resource newResource = resourceSet.createResource(URI.createHierarchicalURI((String)"empty", (String)"JaMoPP-Package", null, (String[])new String[]{packageName, "package-info.java"}, null, null));
                newResource.getContents().add((Object)pack);
            }
        }
    }

    private void convertPureModuleBinding(String modName, Module module, ResourceSet resourceSet) {
        if (!this.objVisited.contains(module)) {
            this.objVisited.add((EObject)module);
            Module potMod = JavaClasspath.get().getModule(modName);
            if (!Objects.equals(potMod, module) && module.eResource() == null) {
                IModuleBinding binding = this.moduleBindings.stream().filter(b -> modName.equals(b.getName())).findFirst().orElse(null);
                if (binding == null) {
                    module.getNamespaces().clear();
                    String[] parts = modName.split("\\.");
                    Collections.addAll(module.getNamespaces(), parts);
                    module.setName("");
                } else {
                    ((Converter)this.bindingToModuleConverter.get()).convert(binding);
                }
                Resource newResource = resourceSet.createResource(URI.createHierarchicalURI((String)"empty", (String)"JaMoPP-Module", null, (String[])new String[]{modName, "module-info.java"}, null, null));
                newResource.getContents().add((Object)module);
            }
        }
    }
}

