/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.parameters.CatchParameter;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.variables.AdditionalLocalVariable;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;
import tools.mdsd.jamopp.parser.interfaces.resolver.ConverterWithBoolean;
import tools.mdsd.jamopp.parser.interfaces.resolver.MethodResolver;
import tools.mdsd.jamopp.parser.interfaces.resolver.Resolver;
import tools.mdsd.jamopp.parser.interfaces.resolver.ResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ResolverWithName;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class ReferenceableElementResolver
implements ResolverWithName<ReferenceableElement, IVariableBinding> {
    private final Set<ITypeBinding> typeBindings;
    private final Set<IMethodBinding> methodBindings;
    private final Set<IVariableBinding> variableBindings;
    private final ToStringConverter<IVariableBinding> toFieldNameConverter;
    private final ConverterWithBoolean<IVariableBinding> toParameterNameConverter;
    private final MethodResolver methodResolver;
    private final Resolver<Classifier, ITypeBinding> classifierResolver;
    private final ResolverWithCache<Annotation, ITypeBinding> annotationResolver;
    private final ResolverWithCache<Enumeration, ITypeBinding> enumerationResolver;
    private final ResolverWithCache<Interface, ITypeBinding> interfaceResolver;
    private final ResolverWithCache<Class, ITypeBinding> classResolver;
    private final ResolverWithCache<TypeParameter, ITypeBinding> typeParameterResolver;
    private final ResolverWithCache<ClassMethod, IMethodBinding> classMethodResolver;
    private final ResolverWithCache<Field, IVariableBinding> fieldResolver;
    private final ResolverWithCache<EnumConstant, IVariableBinding> enumConstantResolver;
    private final ResolverWithCache<AdditionalField, IVariableBinding> additionalFieldResolver;
    private final ResolverWithCache<CatchParameter, IVariableBinding> catchParameterResolver;
    private final ResolverWithCache<OrdinaryParameter, IVariableBinding> ordinaryParameterResolver;
    private final ResolverWithCache<AdditionalLocalVariable, IVariableBinding> additionalLocalVariableResolver;
    private final ResolverWithCache<VariableLengthParameter, IVariableBinding> variableLengthParameterResolver;
    private final ResolverWithCache<LocalVariable, IVariableBinding> localVariableResolver;
    private final ResolverWithCache<InterfaceMethod, IMethodBinding> interfaceMethodResolver;

    @Inject
    public ReferenceableElementResolver(Set<ITypeBinding> typeBindings, Set<IMethodBinding> methodBindings, Set<IVariableBinding> variableBindings, ToStringConverter<IVariableBinding> toFieldNameConverter, ConverterWithBoolean<IVariableBinding> toParameterNameConverter, MethodResolver methodResolver, Resolver<Classifier, ITypeBinding> classifierResolver, ResolverWithCache<Annotation, ITypeBinding> annotationResolver, ResolverWithCache<Enumeration, ITypeBinding> enumerationResolver, ResolverWithCache<Interface, ITypeBinding> interfaceResolver, ResolverWithCache<Class, ITypeBinding> classResolver, ResolverWithCache<TypeParameter, ITypeBinding> typeParameterResolver, ResolverWithCache<ClassMethod, IMethodBinding> classMethodResolver, ResolverWithCache<Field, IVariableBinding> fieldResolver, ResolverWithCache<EnumConstant, IVariableBinding> enumConstantResolver, ResolverWithCache<AdditionalField, IVariableBinding> additionalFieldResolver, ResolverWithCache<CatchParameter, IVariableBinding> catchParameterResolver, ResolverWithCache<OrdinaryParameter, IVariableBinding> ordinaryParameterResolver, ResolverWithCache<AdditionalLocalVariable, IVariableBinding> additionalLocalVariableResolver, ResolverWithCache<VariableLengthParameter, IVariableBinding> variableLengthParameterResolver, ResolverWithCache<LocalVariable, IVariableBinding> localVariableResolver, ResolverWithCache<InterfaceMethod, IMethodBinding> interfaceMethodResolver) {
        this.typeBindings = typeBindings;
        this.methodBindings = methodBindings;
        this.variableBindings = variableBindings;
        this.toFieldNameConverter = toFieldNameConverter;
        this.toParameterNameConverter = toParameterNameConverter;
        this.methodResolver = methodResolver;
        this.classifierResolver = classifierResolver;
        this.annotationResolver = annotationResolver;
        this.enumerationResolver = enumerationResolver;
        this.interfaceResolver = interfaceResolver;
        this.classResolver = classResolver;
        this.typeParameterResolver = typeParameterResolver;
        this.classMethodResolver = classMethodResolver;
        this.fieldResolver = fieldResolver;
        this.enumConstantResolver = enumConstantResolver;
        this.additionalFieldResolver = additionalFieldResolver;
        this.catchParameterResolver = catchParameterResolver;
        this.ordinaryParameterResolver = ordinaryParameterResolver;
        this.additionalLocalVariableResolver = additionalLocalVariableResolver;
        this.variableLengthParameterResolver = variableLengthParameterResolver;
        this.localVariableResolver = localVariableResolver;
        this.interfaceMethodResolver = interfaceMethodResolver;
    }

    @Override
    public ReferenceableElement getByBinding(IVariableBinding binding) {
        String paramName;
        ReferenceableElement referenceableElement = binding.isEnumConstant() ? this.handleIsEnumConstant(binding) : (binding.isField() ? this.handleIsField(binding) : (binding.isParameter() ? this.handleIsParameter(binding) : (this.catchParameterResolver.containsKey(paramName = this.toParameterNameConverter.convertToParameterName(binding, false)) ? (ReferenceableElement)this.catchParameterResolver.get(paramName) : (this.localVariableResolver.containsKey(paramName) ? (ReferenceableElement)this.localVariableResolver.get(paramName) : (this.additionalLocalVariableResolver.containsKey(paramName) ? (ReferenceableElement)this.additionalLocalVariableResolver.getByName(paramName) : (this.ordinaryParameterResolver.containsKey(paramName) ? (ReferenceableElement)this.ordinaryParameterResolver.get(paramName) : (ReferenceableElement)this.localVariableResolver.getByBinding(binding)))))));
        return referenceableElement;
    }

    private ReferenceableElement handleIsEnumConstant(IVariableBinding binding) {
        return (ReferenceableElement)this.enumConstantResolver.getByBinding(binding);
    }

    private ReferenceableElement handleIsParameter(IVariableBinding binding) {
        String paramName = this.toParameterNameConverter.convertToParameterName(binding, false);
        ReferenceableElement referenceableElement = this.ordinaryParameterResolver.containsKey(paramName) ? (ReferenceableElement)this.ordinaryParameterResolver.get(paramName) : (this.variableLengthParameterResolver.containsKey(paramName) ? (ReferenceableElement)this.variableLengthParameterResolver.get(paramName) : (ReferenceableElement)this.ordinaryParameterResolver.getByBinding(binding));
        return referenceableElement;
    }

    private ReferenceableElement handleIsField(IVariableBinding binding) {
        String fieldName = this.toFieldNameConverter.convert(binding);
        ReferenceableElement referenceableElement = this.fieldResolver.containsKey(fieldName) ? (ReferenceableElement)this.fieldResolver.get(fieldName) : (this.additionalFieldResolver.containsKey(fieldName) ? (ReferenceableElement)this.additionalFieldResolver.get(fieldName) : (ReferenceableElement)this.fieldResolver.getByBinding(binding));
        return referenceableElement;
    }

    @Override
    public ReferenceableElement getByName(String name) {
        ArrayList<Stream<Object>> streams = new ArrayList<Stream<Object>>();
        streams.add(this.variableBindings.stream().filter(this.bindingsFilter(name)).map(this::getByBinding));
        streams.add(this.methodBindings.stream().filter(this.methodFilter(name)).map(this.methodResolver::getMethod));
        streams.add(this.typeBindings.stream().filter(this.typeFilter(name)).map(this.classifierResolver::getByBinding));
        streams.add(this.catchParameterResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.localVariableResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.variableLengthParameterResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.ordinaryParameterResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.additionalLocalVariableResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.enumConstantResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.fieldResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.additionalFieldResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.classMethodResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.interfaceMethodResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.typeParameterResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.enumerationResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.annotationResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.classResolver.getBindings().stream().filter(this.filter(name)));
        streams.add(this.interfaceResolver.getBindings().stream().filter(this.filter(name)));
        Optional optionalRefElement = streams.stream().flatMap(s -> s).findFirst();
        ReferenceableElement referenceableElement = optionalRefElement.isPresent() ? (ReferenceableElement)optionalRefElement.get() : (ReferenceableElement)this.classResolver.getByName(name);
        return referenceableElement;
    }

    private Predicate<? super IVariableBinding> bindingsFilter(String name) {
        return param -> param != null && name.equals(param.getName());
    }

    private Predicate<? super IMethodBinding> methodFilter(String name) {
        return param -> !param.isConstructor() && name.equals(param.getName());
    }

    private Predicate<? super ITypeBinding> typeFilter(String name) {
        return param -> param != null && name.equals(param.getName());
    }

    private Predicate<? super NamedElement> filter(String name) {
        return param -> param != null && name.equals(param.getName());
    }
}

