/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.parameters.CatchParameter;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.model.java.variables.AdditionalLocalVariable;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;
import tools.mdsd.jamopp.parser.interfaces.resolver.ClassResolverExtension;
import tools.mdsd.jamopp.parser.interfaces.resolver.MethodCompleter;
import tools.mdsd.jamopp.parser.interfaces.resolver.PureTypeBindingsConverter;
import tools.mdsd.jamopp.parser.interfaces.resolver.ResolutionCompleter;
import tools.mdsd.jamopp.parser.interfaces.resolver.Resolver;
import tools.mdsd.jamopp.parser.interfaces.resolver.ResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class ResolutionCompleterImpl
implements ResolutionCompleter {
    private final boolean extractAdditionalInfosFromTypeBindings;
    private final Map<IVariableBinding, Integer> varBindToUid;
    private final Map<IBinding, String> nameCache;
    private final Set<IModuleBinding> moduleBindings;
    private final Set<IPackageBinding> packageBindings;
    private final Set<ITypeBinding> typeBindings;
    private final Set<IMethodBinding> methodBindings;
    private final Set<IVariableBinding> variableBindings;
    private final Set<EObject> objVisited;
    private final ResolverWithCache<Module, IModuleBinding> moduleResolver;
    private final ResolverWithCache<Package, IPackageBinding> packageResolver;
    private final ResolverWithCache<Annotation, ITypeBinding> annotationResolver;
    private final ResolverWithCache<Enumeration, ITypeBinding> enumerationResolver;
    private final ResolverWithCache<Interface, ITypeBinding> interfaceResolver;
    private final ResolverWithCache<Class, ITypeBinding> classResolver;
    private final ResolverWithCache<TypeParameter, ITypeBinding> typeParameterResolver;
    private final ResolverWithCache<ClassMethod, IMethodBinding> classMethodResolver;
    private final ResolverWithCache<Constructor, IMethodBinding> constructorResolver;
    private final ResolverWithCache<Field, IVariableBinding> fieldResolver;
    private final ResolverWithCache<AnonymousClass, ITypeBinding> anonymousClassResolver;
    private final ResolverWithCache<EnumConstant, IVariableBinding> enumConstantResolver;
    private final ResolverWithCache<AdditionalField, IVariableBinding> additionalFieldResolver;
    private final ResolverWithCache<CatchParameter, IVariableBinding> catchParameterResolver;
    private final ResolverWithCache<OrdinaryParameter, IVariableBinding> ordinaryParameterResolver;
    private final ResolverWithCache<AdditionalLocalVariable, IVariableBinding> additionalLocalVariableResolver;
    private final ResolverWithCache<VariableLengthParameter, IVariableBinding> variableLengthParameterResolver;
    private final ResolverWithCache<LocalVariable, IVariableBinding> localVariableResolver;
    private final ResolverWithCache<InterfaceMethod, IMethodBinding> interfaceMethodResolver;
    private final MethodCompleter methodCompleterImpl;
    private final PureTypeBindingsConverter pureTypeBindingsConverterImpl;
    private final ClassResolverExtension classResolverExtensionImpl;
    private final ToStringConverter<IVariableBinding> toFieldNameConverter;
    private final ToStringConverter<ITypeBinding> toTypeNameConverter;
    private final Resolver<Classifier, ITypeBinding> classifierResolver;

    @Inject
    public ResolutionCompleterImpl(@Named(value="extractAdditionalInfosFromTypeBindings") boolean extractAdditionalInfosFromTypeBindings, Map<IVariableBinding, Integer> varBindToUid, Map<IBinding, String> nameCache, Set<IModuleBinding> moduleBindings, Set<IPackageBinding> packageBindings, Set<ITypeBinding> typeBindings, Set<IMethodBinding> methodBindings, Set<IVariableBinding> variableBindings, Set<EObject> objVisited, ResolverWithCache<Module, IModuleBinding> moduleResolver, ResolverWithCache<Package, IPackageBinding> packageResolver, ResolverWithCache<Annotation, ITypeBinding> annotationResolver, ResolverWithCache<Enumeration, ITypeBinding> enumerationResolver, ResolverWithCache<Interface, ITypeBinding> interfaceResolver, ResolverWithCache<Class, ITypeBinding> classResolver, ResolverWithCache<TypeParameter, ITypeBinding> typeParameterResolver, ResolverWithCache<ClassMethod, IMethodBinding> classMethodResolver, ResolverWithCache<Constructor, IMethodBinding> constructorResolver, ResolverWithCache<Field, IVariableBinding> fieldResolver, ResolverWithCache<AnonymousClass, ITypeBinding> anonymousClassResolver, ResolverWithCache<EnumConstant, IVariableBinding> enumConstantResolver, ResolverWithCache<AdditionalField, IVariableBinding> additionalFieldResolver, ResolverWithCache<CatchParameter, IVariableBinding> catchParameterResolver, ResolverWithCache<OrdinaryParameter, IVariableBinding> ordinaryParameterResolver, ResolverWithCache<AdditionalLocalVariable, IVariableBinding> additionalLocalVariableResolver, ResolverWithCache<VariableLengthParameter, IVariableBinding> variableLengthParameterResolver, ResolverWithCache<LocalVariable, IVariableBinding> localVariableResolver, ResolverWithCache<InterfaceMethod, IMethodBinding> interfaceMethodResolver, MethodCompleter methodCompleterImpl, PureTypeBindingsConverter pureTypeBindingsConverterImpl, ClassResolverExtension classResolverExtensionImpl, ToStringConverter<IVariableBinding> toFieldNameConverter, @Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverter, Resolver<Classifier, ITypeBinding> classifierResolver) {
        this.extractAdditionalInfosFromTypeBindings = extractAdditionalInfosFromTypeBindings;
        this.varBindToUid = varBindToUid;
        this.nameCache = nameCache;
        this.moduleBindings = moduleBindings;
        this.packageBindings = packageBindings;
        this.typeBindings = typeBindings;
        this.methodBindings = methodBindings;
        this.variableBindings = variableBindings;
        this.objVisited = objVisited;
        this.moduleResolver = moduleResolver;
        this.packageResolver = packageResolver;
        this.annotationResolver = annotationResolver;
        this.enumerationResolver = enumerationResolver;
        this.interfaceResolver = interfaceResolver;
        this.classResolver = classResolver;
        this.typeParameterResolver = typeParameterResolver;
        this.classMethodResolver = classMethodResolver;
        this.constructorResolver = constructorResolver;
        this.fieldResolver = fieldResolver;
        this.anonymousClassResolver = anonymousClassResolver;
        this.enumConstantResolver = enumConstantResolver;
        this.additionalFieldResolver = additionalFieldResolver;
        this.catchParameterResolver = catchParameterResolver;
        this.ordinaryParameterResolver = ordinaryParameterResolver;
        this.additionalLocalVariableResolver = additionalLocalVariableResolver;
        this.variableLengthParameterResolver = variableLengthParameterResolver;
        this.localVariableResolver = localVariableResolver;
        this.interfaceMethodResolver = interfaceMethodResolver;
        this.methodCompleterImpl = methodCompleterImpl;
        this.pureTypeBindingsConverterImpl = pureTypeBindingsConverterImpl;
        this.classResolverExtensionImpl = classResolverExtensionImpl;
        this.toFieldNameConverter = toFieldNameConverter;
        this.toTypeNameConverter = toTypeNameConverter;
        this.classifierResolver = classifierResolver;
    }

    @Override
    public void completeResolution(ResourceSet resourceSet) {
        this.enumConstantResolver.forEachBinding(this::handleEnumConstants);
        this.fieldResolver.forEachBinding(this::handleFields);
        this.constructorResolver.forEachBinding((t, u) -> this.methodCompleterImpl.completeMethod((String)t, (Member)u));
        this.classMethodResolver.forEachBinding((t, u) -> this.methodCompleterImpl.completeMethod((String)t, (Member)u));
        this.interfaceMethodResolver.forEachBinding((t, u) -> this.methodCompleterImpl.completeMethod((String)t, (Member)u));
        this.pureTypeBindingsConverterImpl.convertPureTypeBindings(resourceSet);
        this.register();
        this.escapeAllIdentifiers();
        this.clear();
    }

    private void handleFields(String fieldName, Field field) {
        if (field.eContainer() == null) {
            IVariableBinding varBind = this.variableBindings.stream().filter(binding -> binding != null && fieldName.equals(this.toFieldNameConverter.convert((IVariableBinding)binding))).findFirst().orElse(null);
            if (varBind == null || varBind.getDeclaringClass() == null) {
                this.classResolverExtensionImpl.addToSyntheticClass((Member)field);
            } else {
                this.handleFieldsElse(field, varBind);
            }
        }
    }

    private void handleFieldsElse(Field field, IVariableBinding varBind) {
        Classifier cla = this.classifierResolver.getByBinding(varBind.getDeclaringClass());
        if (cla == null) {
            String typeName = this.toTypeNameConverter.convert(varBind.getDeclaringClass());
            if (this.anonymousClassResolver.containsKey(typeName)) {
                AnonymousClass anonClass = this.anonymousClassResolver.get(typeName);
                if (!anonClass.getMembers().contains((Object)field)) {
                    anonClass.getMembers().add((Object)field);
                }
            } else {
                this.classResolverExtensionImpl.addToSyntheticClass((Member)field);
            }
        } else if (!this.extractAdditionalInfosFromTypeBindings && cla instanceof ConcreteClassifier typeName && !classifier.getMembers().contains((Object)field)) {
            classifier.getMembers().add((Object)field);
        }
    }

    private void handleEnumConstants(String constName, EnumConstant enConst) {
        IVariableBinding varBind;
        if (enConst.eContainer() == null && !(varBind = this.variableBindings.stream().filter(binding -> binding != null && constName.equals(this.toFieldNameConverter.convert((IVariableBinding)binding))).findFirst().get()).getDeclaringClass().isAnonymous()) {
            Enumeration enumeration = (Enumeration)this.enumerationResolver.getByBinding(varBind.getDeclaringClass());
            if (!this.extractAdditionalInfosFromTypeBindings && !enumeration.getConstants().contains((Object)enConst)) {
                enumeration.getConstants().add((Object)enConst);
            }
        }
    }

    private void register() {
        this.moduleResolver.getBindings().forEach(module -> JavaClasspath.get().registerModule(module));
        this.packageResolver.getBindings().forEach(pack -> JavaClasspath.get().registerPackage(pack));
        this.annotationResolver.getBindings().forEach(ann -> JavaClasspath.get().registerConcreteClassifier((ConcreteClassifier)ann));
        this.enumerationResolver.getBindings().forEach(enume -> JavaClasspath.get().registerConcreteClassifier((ConcreteClassifier)enume));
        this.interfaceResolver.getBindings().forEach(interf -> JavaClasspath.get().registerConcreteClassifier((ConcreteClassifier)interf));
        this.classResolver.getBindings().forEach(clazz -> JavaClasspath.get().registerConcreteClassifier((ConcreteClassifier)clazz));
    }

    private void clear() {
        this.moduleResolver.clearBindings();
        this.packageResolver.clearBindings();
        this.annotationResolver.clearBindings();
        this.enumerationResolver.clearBindings();
        this.interfaceResolver.clearBindings();
        this.classResolver.clearBindings();
        this.typeParameterResolver.clearBindings();
        this.classMethodResolver.clearBindings();
        this.constructorResolver.clearBindings();
        this.fieldResolver.clearBindings();
        this.interfaceMethodResolver.clearBindings();
        this.additionalFieldResolver.clearBindings();
        this.localVariableResolver.clearBindings();
        this.additionalLocalVariableResolver.clearBindings();
        this.enumConstantResolver.clearBindings();
        this.variableLengthParameterResolver.clearBindings();
        this.ordinaryParameterResolver.clearBindings();
        this.catchParameterResolver.clearBindings();
        this.moduleBindings.clear();
        this.packageBindings.clear();
        this.typeBindings.clear();
        this.methodBindings.clear();
        this.variableBindings.clear();
        this.varBindToUid.clear();
        this.objVisited.clear();
        this.nameCache.clear();
        this.anonymousClassResolver.clearBindings();
    }

    private void escapeAllIdentifiers() {
        this.moduleResolver.getBindings().forEach(this::escapeIdentifiers);
        this.packageResolver.getBindings().forEach(this::escapeIdentifiers);
        this.annotationResolver.getBindings().forEach(this::escapeIdentifiers);
        this.enumerationResolver.getBindings().forEach(this::escapeIdentifiers);
        this.classResolver.getBindings().forEach(this::escapeIdentifiers);
        this.interfaceResolver.getBindings().forEach(this::escapeIdentifiers);
    }

    private void escapeIdentifiers(EObject obj) {
        obj.eAllContents().forEachRemaining(this::escapeIdentifier);
    }

    /*
     * WARNING - void declaration
     */
    private void escapeIdentifier(Notifier not) {
        void var3_2;
        NamedElement namedElement;
        Notifier notifier = not;
        if (notifier instanceof NamedElement && (namedElement = (NamedElement)notifier) == (NamedElement)var3_2) {
            void ele;
            StringBuilder builder = new StringBuilder();
            String name = ele.getName();
            name.codePoints().forEach(i -> {
                if (i <= 32 || 55296 <= i && i <= 57343) {
                    builder.append("\\u").append(String.format("%04x", i));
                } else {
                    builder.appendCodePoint(i);
                }
            });
            ele.setName(builder.toString());
        }
    }
}

