/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class ToFieldNameConverter
implements ToStringConverter<IVariableBinding> {
    private final Map<IBinding, String> nameCache;
    private final ToStringConverter<ITypeBinding> toTypeNameConverter;

    @Inject
    public ToFieldNameConverter(@Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverter, Map<IBinding, String> nameCache) {
        this.nameCache = nameCache;
        this.toTypeNameConverter = toTypeNameConverter;
    }

    @Override
    public String convert(IVariableBinding binding) {
        String result;
        if (binding == null || !binding.isField()) {
            result = "";
        } else if (this.nameCache.containsKey(binding)) {
            result = this.nameCache.get(binding);
        } else {
            String name = String.valueOf(this.toTypeNameConverter.convert(binding.getDeclaringClass())) + "::" + binding.getName();
            this.nameCache.put((IBinding)binding, name);
            result = name;
        }
        return result;
    }
}

