/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class ToMethodNameConverter
implements ToStringConverter<IMethodBinding> {
    private static final String JAVA_LANG_OBJECT_CLONE = "java.lang.Object::clone()";
    private final Map<IBinding, String> nameCache;
    private final ToStringConverter<ITypeBinding> toTypeNameConverter;

    @Inject
    public ToMethodNameConverter(@Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverter, Map<IBinding, String> nameCache) {
        this.nameCache = nameCache;
        this.toTypeNameConverter = toTypeNameConverter;
    }

    @Override
    public String convert(IMethodBinding binding) {
        String result = binding == null ? "" : (this.nameCache.containsKey(binding) ? this.nameCache.get(binding) : this.handleElse(binding));
        return result;
    }

    private String handleElse(IMethodBinding binding) {
        IMethodBinding methodDeclaration = binding.getMethodDeclaration();
        StringBuilder builder = new StringBuilder();
        builder.append(this.toTypeNameConverter.convert(methodDeclaration.getDeclaringClass())).append("::").append(methodDeclaration.getName()).append('(');
        ITypeBinding[] iTypeBindingArray = methodDeclaration.getParameterTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding p = iTypeBindingArray[n2];
            builder.append(this.toTypeNameConverter.convert(p));
            int i = 0;
            while (i < p.getDimensions()) {
                builder.append("[]");
                ++i;
            }
            ++n2;
        }
        builder.append(')');
        if (JAVA_LANG_OBJECT_CLONE.equals(builder.toString()) && methodDeclaration.getReturnType().isArray()) {
            builder.append("java.lang.Object");
        } else {
            builder.append(this.toTypeNameConverter.convert(methodDeclaration.getReturnType()));
        }
        String name = builder.toString();
        this.nameCache.put((IBinding)methodDeclaration, name);
        return name;
    }
}

