/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.parser.interfaces.resolver.ConverterWithBoolean;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;
import tools.mdsd.jamopp.parser.interfaces.resolver.UidManager;

public class ToParameterNameConverter
implements ConverterWithBoolean<IVariableBinding> {
    private final Map<IVariableBinding, Integer> varBindToUid;
    private final Map<IBinding, String> nameCache;
    private final UidManager uidManagerImpl;
    private final ToStringConverter<IMethodBinding> toMethodNameConverter;

    @Inject
    public ToParameterNameConverter(Map<IVariableBinding, Integer> varBindToUid, UidManager uidManagerImpl, ToStringConverter<IMethodBinding> toMethodNameConverter, Map<IBinding, String> nameCache) {
        this.varBindToUid = varBindToUid;
        this.nameCache = nameCache;
        this.uidManagerImpl = uidManagerImpl;
        this.toMethodNameConverter = toMethodNameConverter;
    }

    @Override
    public String convertToParameterName(IVariableBinding binding, boolean register) {
        String result;
        if (binding == null) {
            result = "";
        } else if (this.nameCache.containsKey(binding)) {
            result = this.nameCache.get(binding);
        } else {
            String prefix;
            if (binding.getDeclaringMethod() != null) {
                prefix = this.toMethodNameConverter.convert(binding.getDeclaringMethod());
            } else if (this.varBindToUid.containsKey(binding)) {
                prefix = String.valueOf(this.varBindToUid.get(binding));
            } else {
                prefix = String.valueOf(this.uidManagerImpl.getUid());
                if (register) {
                    this.varBindToUid.put(binding, this.uidManagerImpl.getUid());
                }
            }
            String name = String.valueOf(prefix) + "::" + binding.getName() + "::" + binding.getVariableId() + binding.hashCode();
            this.nameCache.put((IBinding)binding, name);
            result = name;
        }
        return result;
    }
}

