/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Map;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class ToTypeNameConverterFromBinding
implements ToStringConverter<ITypeBinding> {
    private final Map<IBinding, String> nameCache;
    private final Provider<ToStringConverter<IMethodBinding>> toMethodNameConverter;
    private final ToStringConverter<IVariableBinding> toFieldNameConverter;

    @Inject
    public ToTypeNameConverterFromBinding(Provider<ToStringConverter<IMethodBinding>> toMethodNameConverter, ToStringConverter<IVariableBinding> toFieldNameConverter, Map<IBinding, String> nameCache) {
        this.nameCache = nameCache;
        this.toMethodNameConverter = toMethodNameConverter;
        this.toFieldNameConverter = toFieldNameConverter;
    }

    @Override
    public String convert(ITypeBinding binding) {
        String result = binding == null ? "" : (binding.isTypeVariable() ? binding.getName() : (this.nameCache.containsKey(binding) ? this.nameCache.get(binding) : (binding.isLocal() ? this.handleLocal(binding) : this.handleElse(binding))));
        return result;
    }

    private String handleElse(ITypeBinding binding) {
        String qualifiedName = binding.isMember() ? String.valueOf(this.convert(binding.getDeclaringClass())) + "." + binding.getName() : binding.getQualifiedName();
        if (qualifiedName.contains("<")) {
            qualifiedName = qualifiedName.substring(0, qualifiedName.indexOf(60));
        }
        this.nameCache.put((IBinding)binding, qualifiedName);
        return qualifiedName;
    }

    private String handleLocal(ITypeBinding binding) {
        IBinding iBinding = binding.getDeclaringMember();
        String qualifiedName = iBinding instanceof IMethodBinding ? String.valueOf(((ToStringConverter)this.toMethodNameConverter.get()).convert((IMethodBinding)iBinding)) + "." + binding.getKey() : (iBinding instanceof IVariableBinding ? String.valueOf(this.toFieldNameConverter.convert((IVariableBinding)iBinding)) + "." + binding.getKey() : binding.getKey());
        this.nameCache.put((IBinding)binding, qualifiedName);
        return qualifiedName;
    }
}

