/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.types.Boolean;
import tools.mdsd.jamopp.model.java.types.Byte;
import tools.mdsd.jamopp.model.java.types.Char;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.Double;
import tools.mdsd.jamopp.model.java.types.Float;
import tools.mdsd.jamopp.model.java.types.InferableType;
import tools.mdsd.jamopp.model.java.types.Int;
import tools.mdsd.jamopp.model.java.types.Long;
import tools.mdsd.jamopp.model.java.types.NamespaceClassifierReference;
import tools.mdsd.jamopp.model.java.types.Short;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.Void;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class ToTypeNameConverterFromReference
implements ToStringConverter<TypeReference> {
    private final Map<Class<?>, Function<TypeReference, String>> mapping = new HashMap();

    public ToTypeNameConverterFromReference() {
        this.mapping.put(ClassifierReference.class, convRef -> this.convertClassifierReference((ClassifierReference)convRef));
        this.mapping.put(NamespaceClassifierReference.class, convRef -> this.convertNamespaceClassifierReference((NamespaceClassifierReference)convRef));
        this.mapping.put(Boolean.class, convRef -> "boolean");
        this.mapping.put(Byte.class, convRef -> "byte");
        this.mapping.put(Char.class, convRef -> "char");
        this.mapping.put(Double.class, convRef -> "double");
        this.mapping.put(Float.class, convRef -> "float");
        this.mapping.put(Int.class, convRef -> "int");
        this.mapping.put(Long.class, convRef -> "long");
        this.mapping.put(Short.class, convRef -> "short");
        this.mapping.put(Void.class, convRef -> "void");
    }

    @Override
    public String convert(TypeReference ref) {
        String result = null;
        for (Map.Entry<Class<?>, Function<TypeReference, String>> entry : this.mapping.entrySet()) {
            Class<?> key = entry.getKey();
            Function<TypeReference, String> val = entry.getValue();
            if (!key.isInstance(ref)) continue;
            result = val.apply(ref);
            break;
        }
        return result;
    }

    private String convertClassifierReference(ClassifierReference convRef) {
        String result = convRef.getTarget() instanceof ConcreteClassifier ? ((ConcreteClassifier)convRef.getTarget()).getQualifiedName() : (convRef.getTarget() instanceof InferableType ? "var" : ((TypeParameter)convRef.getTarget()).getName());
        return result;
    }

    private String convertNamespaceClassifierReference(NamespaceClassifierReference nRef) {
        String result = nRef.getClassifierReferences().isEmpty() ? nRef.getNamespacesAsString() : this.convert((TypeReference)nRef.getClassifierReferences().get(nRef.getClassifierReferences().size() - 1));
        return result;
    }
}

