/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class ToTypeParameterNameConverter
implements ToStringConverter<ITypeBinding> {
    private final Map<IBinding, String> nameCache;
    private final ToStringConverter<ITypeBinding> toTypeNameConverter;
    private final ToStringConverter<IMethodBinding> toMethodNameConverter;

    @Inject
    public ToTypeParameterNameConverter(@Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverter, ToStringConverter<IMethodBinding> toMethodNameConverter, Map<IBinding, String> nameCache) {
        this.nameCache = nameCache;
        this.toTypeNameConverter = toTypeNameConverter;
        this.toMethodNameConverter = toMethodNameConverter;
    }

    @Override
    public String convert(ITypeBinding binding) {
        String result;
        if (binding == null) {
            result = "";
        } else if (this.nameCache.containsKey(binding)) {
            result = this.nameCache.get(binding);
        } else {
            StringBuilder name = new StringBuilder();
            if (binding.getDeclaringClass() != null) {
                name.append(this.toTypeNameConverter.convert(binding.getDeclaringClass()));
            } else if (binding.getDeclaringMethod() != null) {
                name.append(this.toMethodNameConverter.convert(binding.getDeclaringMethod()));
            }
            name.append('.').append(binding.getName());
            this.nameCache.put((IBinding)binding, name.toString());
            result = name.toString();
        }
        return result;
    }
}

