/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.generics.GenericsFactory;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class TypeParameterResolver
extends AbstractResolverWithCache<TypeParameter, ITypeBinding> {
    private final Set<ITypeBinding> typeBindings;
    private final GenericsFactory genericsFactory;
    private final ToStringConverter<ITypeBinding> toTypeParameterNameConverter;

    @Inject
    public TypeParameterResolver(Map<String, TypeParameter> bindings, Set<ITypeBinding> typeBindings, GenericsFactory genericsFactory, @Named(value="ToTypeParameterNameConverter") ToStringConverter<ITypeBinding> toTypeParameterNameConverter) {
        super(bindings);
        this.typeBindings = typeBindings;
        this.genericsFactory = genericsFactory;
        this.toTypeParameterNameConverter = toTypeParameterNameConverter;
    }

    @Override
    public TypeParameter getByBinding(ITypeBinding binding) {
        TypeParameter typeParameter;
        String paramName = this.toTypeParameterNameConverter.convert(binding);
        if (this.containsKey(paramName)) {
            typeParameter = (TypeParameter)this.get(paramName);
        } else {
            this.typeBindings.add(binding);
            TypeParameter result = this.genericsFactory.createTypeParameter();
            this.putBinding(paramName, result);
            typeParameter = result;
        }
        return typeParameter;
    }

    @Override
    public TypeParameter getByName(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

