/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.model.java.parameters.ParametersFactory;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ConverterWithBoolean;

public class VariableLengthParameterResolver
extends AbstractResolverWithCache<VariableLengthParameter, IVariableBinding> {
    private final Set<IVariableBinding> variableBindings;
    private final ParametersFactory parametersFactory;
    private final ConverterWithBoolean<IVariableBinding> toParameterNameConverter;

    @Inject
    public VariableLengthParameterResolver(Map<String, VariableLengthParameter> bindings, Set<IVariableBinding> variableBindings, ParametersFactory parametersFactory, ConverterWithBoolean<IVariableBinding> toParameterNameConverter) {
        super(bindings);
        this.variableBindings = variableBindings;
        this.parametersFactory = parametersFactory;
        this.toParameterNameConverter = toParameterNameConverter;
    }

    @Override
    public VariableLengthParameter getByBinding(IVariableBinding binding) {
        VariableLengthParameter variableLengthParameter;
        String paramName = this.toParameterNameConverter.convertToParameterName(binding, true);
        if (this.containsKey(paramName)) {
            variableLengthParameter = (VariableLengthParameter)this.get(paramName);
        } else {
            this.variableBindings.add(binding);
            VariableLengthParameter result = this.parametersFactory.createVariableLengthParameter();
            this.putBinding(paramName, result);
            variableLengthParameter = result;
        }
        return variableLengthParameter;
    }

    @Override
    public VariableLengthParameter getByName(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

