/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.visitor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.containers.ContainersFactory;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.imports.Import;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;
import tools.mdsd.jamopp.parser.interfaces.visitor.AbstractVisitor;

@Singleton
public class VisitorAndConverterAbstractAndEmptyModelJDTAST
extends AbstractVisitor {
    private final ContainersFactory containersFactory;
    private final UtilLayout layoutInformationConverter;
    private final UtilNamedElement utilNamedElement;
    private final JdtResolver jdtResolverUtility;
    private final Converter<Annotation, AnnotationInstance> annotationInstanceConverter;
    private final Converter<ImportDeclaration, Import> toImportConverter;
    private final Provider<Converter<CompilationUnit, tools.mdsd.jamopp.model.java.containers.CompilationUnit>> toCompilationUnitConverter;
    private final Provider<Converter<ModuleDeclaration, Module>> toModuleConverter;
    private JavaRoot convertedRootElement;
    private String originalSource;

    @Inject
    public VisitorAndConverterAbstractAndEmptyModelJDTAST(UtilNamedElement utilNamedElement, @Named(value="ToImportConverter") Converter<ImportDeclaration, Import> toImportConverter, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility, ContainersFactory containersFactory, Converter<Annotation, AnnotationInstance> annotationInstanceConverter, Provider<Converter<ModuleDeclaration, Module>> toModuleConverter, Provider<Converter<CompilationUnit, tools.mdsd.jamopp.model.java.containers.CompilationUnit>> toCompilationUnitConverter) {
        this.containersFactory = containersFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.utilNamedElement = utilNamedElement;
        this.jdtResolverUtility = jdtResolverUtility;
        this.annotationInstanceConverter = annotationInstanceConverter;
        this.toImportConverter = toImportConverter;
        this.toCompilationUnitConverter = toCompilationUnitConverter;
        this.toModuleConverter = toModuleConverter;
    }

    @Override
    public void setSource(String src) {
        this.originalSource = src;
    }

    @Override
    public String getSource() {
        return this.originalSource;
    }

    @Override
    public void setConvertedElement(JavaRoot root) {
        this.convertedRootElement = root;
    }

    @Override
    public JavaRoot getConvertedElement() {
        return this.convertedRootElement;
    }

    @Override
    public boolean visit(CompilationUnit node) {
        this.setConvertedElement(null);
        if (!node.types().isEmpty()) {
            this.setConvertedElement((JavaRoot)((Converter)this.toCompilationUnitConverter.get()).convert(node));
        }
        if (node.getModule() != null) {
            Module module = (Module)((Converter)this.toModuleConverter.get()).convert(node.getModule());
            this.setConvertedElement((JavaRoot)module);
        }
        if (this.convertedRootElement == null && node.getPackage() != null) {
            this.convertedRootElement = this.jdtResolverUtility.getPackage(node.getPackage().resolveBinding());
            this.convertedRootElement.setName("");
            this.layoutInformationConverter.convertJavaRootLayoutInformation(this.convertedRootElement, (ASTNode)node, this.getSource());
            this.setConvertedElement(this.convertedRootElement);
        }
        if (this.convertedRootElement != null && node.getPackage() != null) {
            node.getPackage().annotations().forEach(obj -> {
                boolean bl = this.convertedRootElement.getAnnotations().add((Object)this.annotationInstanceConverter.convert((Annotation)obj));
            });
            this.convertedRootElement.getNamespaces().clear();
            this.utilNamedElement.addNameToNameSpace(node.getPackage().getName(), (NamespaceAwareElement)this.convertedRootElement);
        }
        if (this.convertedRootElement == null) {
            this.convertedRootElement = this.containersFactory.createEmptyModel();
            this.convertedRootElement.setName("");
        }
        for (Object obj2 : node.imports()) {
            this.convertedRootElement.getImports().add((Object)this.toImportConverter.convert((ImportDeclaration)obj2));
        }
        return false;
    }
}

