/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.printer.injection.ModulePrinterInjection;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public final class JaMoPPPrinter {
    private static final Printer<JavaRoot> JAVA_ROOT_PRINTER = (Printer)Guice.createInjector((Module[])new Module[]{new ModulePrinterInjection()}).getInstance((Key)new Key<Printer<JavaRoot>>(){});

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void print(JavaRoot root, OutputStream output) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                OutputStreamWriter outWriter = new OutputStreamWriter(output, StandardCharsets.UTF_8);
                try {
                    try (BufferedWriter buffWriter = new BufferedWriter(outWriter);){
                        JAVA_ROOT_PRINTER.print(root, buffWriter);
                    }
                    if (outWriter == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (outWriter == null) throw throwable;
                    outWriter.close();
                    throw throwable;
                }
                outWriter.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void print(JavaRoot root, Path file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
                JAVA_ROOT_PRINTER.print(root, writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private JaMoPPPrinter() {
    }
}

