/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import javax.inject.Provider;
import tools.mdsd.jamopp.model.java.annotations.AnnotationAttributeSetting;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.annotations.AnnotationParameterList;
import tools.mdsd.jamopp.model.java.annotations.AnnotationValue;
import tools.mdsd.jamopp.model.java.annotations.SingleAnnotationParameter;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class AnnotationInstancePrinterImpl
implements Printer<AnnotationInstance> {
    private final Provider<Printer<AnnotationValue>> annotationValuePrinter;

    @Inject
    public AnnotationInstancePrinterImpl(Provider<Printer<AnnotationValue>> annotationValuePrinter) {
        this.annotationValuePrinter = annotationValuePrinter;
    }

    @Override
    public void print(AnnotationInstance element, BufferedWriter writer) throws IOException {
        writer.append("@" + element.getNamespacesAsString());
        if (element.getParameter() != null) {
            writer.append("(");
            if (element.getParameter() instanceof SingleAnnotationParameter) {
                ((Printer)this.annotationValuePrinter.get()).print(((SingleAnnotationParameter)element.getParameter()).getValue(), writer);
            } else {
                AnnotationParameterList list = (AnnotationParameterList)element.getParameter();
                int index = 0;
                while (index < list.getSettings().size()) {
                    AnnotationAttributeSetting setting = (AnnotationAttributeSetting)list.getSettings().get(index);
                    writer.append(String.valueOf(setting.getAttribute().getName()) + " = ");
                    ((Printer)this.annotationValuePrinter.get()).print(setting.getValue(), writer);
                    if (index < list.getSettings().size() - 1) {
                        writer.append(", ");
                    }
                    ++index;
                }
            }
            writer.append(")");
        }
        writer.append("\n");
    }
}

