/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.references.Argumentable;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class ArgumentablePrinterImpl
implements Printer<Argumentable> {
    private final Printer<Expression> expressionPrinter;

    @Inject
    public ArgumentablePrinterImpl(Printer<Expression> expressionPrinter) {
        this.expressionPrinter = expressionPrinter;
    }

    @Override
    public void print(Argumentable element, BufferedWriter writer) throws IOException {
        writer.append("(");
        int index = 0;
        while (index < element.getArguments().size()) {
            this.expressionPrinter.print((Expression)element.getArguments().get(index), writer);
            if (index < element.getArguments().size() - 1) {
                writer.append(", ");
            }
            ++index;
        }
        writer.append(")");
    }
}

