/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.arrays.ArrayInitializationValue;
import tools.mdsd.jamopp.model.java.arrays.ArrayInitializer;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class ArrayInitializerPrinterImpl
implements Printer<ArrayInitializer> {
    private final Printer<AnnotationInstance> annotationInstancePrinter;
    private final Printer<Expression> expressionPrinter;

    @Inject
    public ArrayInitializerPrinterImpl(Printer<AnnotationInstance> annotationInstancePrinter, Printer<Expression> expressionPrinter) {
        this.annotationInstancePrinter = annotationInstancePrinter;
        this.expressionPrinter = expressionPrinter;
    }

    @Override
    public void print(ArrayInitializer element, BufferedWriter writer) throws IOException {
        writer.append("{");
        int index = 0;
        while (index < element.getInitialValues().size()) {
            ArrayInitializationValue val = (ArrayInitializationValue)element.getInitialValues().get(index);
            if (val instanceof AnnotationInstance) {
                this.annotationInstancePrinter.print((AnnotationInstance)val, writer);
            } else if (val instanceof ArrayInitializer) {
                this.print((ArrayInitializer)val, writer);
            } else {
                this.expressionPrinter.print((Expression)val, writer);
            }
            if (index < element.getInitialValues().size() - 1) {
                writer.append(", ");
            }
            ++index;
        }
        writer.append("}");
    }
}

