/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import tools.mdsd.jamopp.model.java.arrays.ArrayDimension;
import tools.mdsd.jamopp.model.java.arrays.ArrayInitializer;
import tools.mdsd.jamopp.model.java.arrays.ArrayInstantiation;
import tools.mdsd.jamopp.model.java.arrays.ArrayInstantiationBySize;
import tools.mdsd.jamopp.model.java.arrays.ArrayInstantiationByValuesTyped;
import tools.mdsd.jamopp.model.java.arrays.ArrayInstantiationByValuesUntyped;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.generics.TypeArgumentable;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class ArrayInstantiationPrinterImpl
implements Printer<ArrayInstantiation> {
    private final Printer<List<ArrayDimension>> arrayDimensionsPrinter;
    private final Printer<ArrayInitializer> arrayInitializerPrinter;
    private final Printer<Expression> expressionPrinter;
    private final Printer<TypeArgumentable> typeArgumentablePrinter;
    private final Printer<TypeReference> typeReferencePrinter;

    @Inject
    public ArrayInstantiationPrinterImpl(Printer<TypeReference> typeReferencePrinter, Printer<TypeArgumentable> typeArgumentablePrinter, Printer<Expression> expressionPrinter, Printer<List<ArrayDimension>> arrayDimensionsPrinter, Printer<ArrayInitializer> arrayInitializerPrinter) {
        this.typeReferencePrinter = typeReferencePrinter;
        this.typeArgumentablePrinter = typeArgumentablePrinter;
        this.expressionPrinter = expressionPrinter;
        this.arrayDimensionsPrinter = arrayDimensionsPrinter;
        this.arrayInitializerPrinter = arrayInitializerPrinter;
    }

    @Override
    public void print(ArrayInstantiation element, BufferedWriter writer) throws IOException {
        if (element instanceof ArrayInstantiationBySize var3_4) {
            this.printArrayInstantiationBySize(writer, (ArrayInstantiationBySize)inst);
        } else {
            if (element instanceof ArrayInstantiationByValuesUntyped var5_6) {
                this.printArrayInstantiationByValuesUntyped(writer, (ArrayInstantiationByValuesUntyped)inst);
            } else {
                this.printArrayInstantiationByValuesTyped(element, writer);
            }
        }
    }

    private void printArrayInstantiationByValuesTyped(ArrayInstantiation element, BufferedWriter writer) throws IOException {
        ArrayInstantiationByValuesTyped inst = (ArrayInstantiationByValuesTyped)element;
        writer.append("new ");
        this.typeReferencePrinter.print(inst.getTypeReference(), writer);
        this.typeArgumentablePrinter.print((TypeArgumentable)inst, writer);
        this.arrayDimensionsPrinter.print((List<ArrayDimension>)inst.getArrayDimensionsBefore(), writer);
        this.arrayDimensionsPrinter.print((List<ArrayDimension>)inst.getArrayDimensionsAfter(), writer);
        writer.append(" ");
        this.arrayInitializerPrinter.print(inst.getArrayInitializer(), writer);
    }

    private void printArrayInstantiationByValuesUntyped(BufferedWriter writer, ArrayInstantiationByValuesUntyped inst) throws IOException {
        this.arrayInitializerPrinter.print(inst.getArrayInitializer(), writer);
    }

    private void printArrayInstantiationBySize(BufferedWriter writer, ArrayInstantiationBySize inst) throws IOException {
        writer.append("new ");
        this.typeReferencePrinter.print(inst.getTypeReference(), writer);
        this.typeArgumentablePrinter.print((TypeArgumentable)inst, writer);
        writer.append(" ");
        for (Expression expr : inst.getSizes()) {
            writer.append("[");
            this.expressionPrinter.print(expr, writer);
            writer.append("] ");
        }
        this.arrayDimensionsPrinter.print((List<ArrayDimension>)inst.getArrayDimensionsBefore(), writer);
        this.arrayDimensionsPrinter.print((List<ArrayDimension>)inst.getArrayDimensionsAfter(), writer);
    }
}

