/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import tools.mdsd.jamopp.model.java.arrays.ArrayDimension;
import tools.mdsd.jamopp.model.java.expressions.CastExpression;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class CastExpressionPrinterImpl
implements Printer<CastExpression> {
    private final Printer<List<ArrayDimension>> arrayDimensionsPrinter;
    private final Printer<Expression> expressionPrinter;
    private final Printer<TypeReference> typeReferencePrinter;

    @Inject
    public CastExpressionPrinterImpl(Printer<TypeReference> typeReferencePrinter, Printer<List<ArrayDimension>> arrayDimensionsPrinter, Printer<Expression> expressionPrinter) {
        this.typeReferencePrinter = typeReferencePrinter;
        this.arrayDimensionsPrinter = arrayDimensionsPrinter;
        this.expressionPrinter = expressionPrinter;
    }

    @Override
    public void print(CastExpression element, BufferedWriter writer) throws IOException {
        writer.append("(");
        this.typeReferencePrinter.print(element.getTypeReference(), writer);
        this.arrayDimensionsPrinter.print((List<ArrayDimension>)element.getArrayDimensionsBefore(), writer);
        this.arrayDimensionsPrinter.print((List<ArrayDimension>)element.getArrayDimensionsAfter(), writer);
        for (TypeReference ref : element.getAdditionalBounds()) {
            writer.append(" & ");
            this.typeReferencePrinter.print(ref, writer);
        }
        writer.append(") ");
        this.expressionPrinter.print(element.getGeneralChild(), writer);
    }
}

