/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import tools.mdsd.jamopp.model.java.arrays.ArrayDimension;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.generics.TypeParametrizable;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.ExceptionThrower;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.modifiers.Modifier;
import tools.mdsd.jamopp.model.java.modifiers.Public;
import tools.mdsd.jamopp.model.java.modifiers.Static;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.Parametrizable;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class ClassMethodPrinterImpl
implements Printer<ClassMethod> {
    private static final String VALUES = "values";
    private static final String VALUE_OF = "valueOf";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private final Printer<AnnotableAndModifiable> annotableAndModifiablePrinter;
    private final Printer<List<ArrayDimension>> arrayDimensionsPrinter;
    private final Printer<ExceptionThrower> exceptionThrowerPrinter;
    private final Printer<Parametrizable> parametrizablePrinter;
    private final Printer<Statement> statementPrinter;
    private final Printer<TypeParametrizable> typeParametrizablePrinter;
    private final Printer<TypeReference> typeReferencePrinter;

    @Inject
    public ClassMethodPrinterImpl(Printer<AnnotableAndModifiable> annotableAndModifiablePrinter, Printer<TypeParametrizable> typeParametrizablePrinter, Printer<TypeReference> typeReferencePrinter, Printer<List<ArrayDimension>> arrayDimensionsPrinter, Printer<Parametrizable> parametrizablePrinter, Printer<ExceptionThrower> exceptionThrowerPrinter, Printer<Statement> statementPrinter) {
        this.annotableAndModifiablePrinter = annotableAndModifiablePrinter;
        this.typeParametrizablePrinter = typeParametrizablePrinter;
        this.typeReferencePrinter = typeReferencePrinter;
        this.arrayDimensionsPrinter = arrayDimensionsPrinter;
        this.parametrizablePrinter = parametrizablePrinter;
        this.exceptionThrowerPrinter = exceptionThrowerPrinter;
        this.statementPrinter = statementPrinter;
    }

    @Override
    public void print(ClassMethod element, BufferedWriter writer) throws IOException {
        if (this.shouldNotBePrinted(element)) {
            return;
        }
        this.annotableAndModifiablePrinter.print((AnnotableAndModifiable)element, writer);
        this.typeParametrizablePrinter.print((TypeParametrizable)element, writer);
        writer.append(" ");
        this.typeReferencePrinter.print(element.getTypeReference(), writer);
        this.arrayDimensionsPrinter.print((List<ArrayDimension>)element.getArrayDimensionsBefore(), writer);
        writer.append(" " + element.getName());
        this.parametrizablePrinter.print((Parametrizable)element, writer);
        this.arrayDimensionsPrinter.print((List<ArrayDimension>)element.getArrayDimensionsAfter(), writer);
        this.exceptionThrowerPrinter.print((ExceptionThrower)element, writer);
        writer.append(" ");
        this.statementPrinter.print(element.getStatement(), writer);
        writer.append("\n");
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldNotBePrinted(ClassMethod element) {
        boolean isStaticAndPublic;
        boolean returnValue = false;
        if (element.eContainer() instanceof Enumeration && (isStaticAndPublic = this.checkIfStaticAndPublic(element))) {
            void cla;
            Class clazz;
            Type type;
            returnValue = VALUE_OF.equals(element.getName()) && element.getParameters().size() == 1 && (type = ((Parameter)element.getParameters().get(0)).getTypeReference().getTarget()) instanceof Class && (clazz = (Class)type) == (Class)type && JAVA_LANG_STRING.equals(cla.getQualifiedName()) || VALUES.equals(element.getName()) && element.getParameters().isEmpty();
        }
        return returnValue;
    }

    private boolean checkIfStaticAndPublic(ClassMethod element) {
        boolean isStatic = false;
        boolean isPublic = false;
        for (Modifier m : element.getModifiers()) {
            if (m instanceof Static) {
                isStatic = true;
                continue;
            }
            if (!(m instanceof Public)) continue;
            isPublic = true;
        }
        return isStatic && isPublic;
    }
}

