/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Implementor;
import tools.mdsd.jamopp.model.java.generics.TypeParametrizable;
import tools.mdsd.jamopp.model.java.members.MemberContainer;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class ClassPrinterImpl
implements Printer<Class> {
    private final Printer<AnnotableAndModifiable> annotableAndModifiablePrinter;
    private final Printer<Implementor> implementorPrinter;
    private final Printer<MemberContainer> memberContainerPrinter;
    private final Printer<TypeParametrizable> typeParametrizablePrinter;
    private final Printer<TypeReference> typeReferencePrinter;

    @Inject
    public ClassPrinterImpl(Printer<AnnotableAndModifiable> annotableAndModifiablePrinter, Printer<TypeParametrizable> typeParametrizablePrinter, Printer<TypeReference> typeReferencePrinter, Printer<Implementor> implementorPrinter, Printer<MemberContainer> memberContainerPrinter) {
        this.annotableAndModifiablePrinter = annotableAndModifiablePrinter;
        this.typeParametrizablePrinter = typeParametrizablePrinter;
        this.typeReferencePrinter = typeReferencePrinter;
        this.implementorPrinter = implementorPrinter;
        this.memberContainerPrinter = memberContainerPrinter;
    }

    @Override
    public void print(Class element, BufferedWriter writer) throws IOException {
        this.annotableAndModifiablePrinter.print((AnnotableAndModifiable)element, writer);
        writer.append("class " + element.getName());
        this.typeParametrizablePrinter.print((TypeParametrizable)element, writer);
        writer.append(" ");
        if (element.getExtends() != null) {
            writer.append("extends ");
            this.typeReferencePrinter.print(element.getExtends(), writer);
            writer.append(" ");
        }
        this.implementorPrinter.print((Implementor)element, writer);
        writer.append("{\n");
        this.memberContainerPrinter.print((MemberContainer)element, writer);
        writer.append("}\n");
    }
}

