/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.statements.Condition;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class ConditionPrinterImpl
implements Printer<Condition> {
    private final Printer<Expression> expressionPrinter;
    private final Printer<Statement> statementPrinter;

    @Inject
    public ConditionPrinterImpl(Printer<Expression> expressionPrinter, Printer<Statement> statementPrinter) {
        this.expressionPrinter = expressionPrinter;
        this.statementPrinter = statementPrinter;
    }

    @Override
    public void print(Condition element, BufferedWriter writer) throws IOException {
        writer.append("if (");
        this.expressionPrinter.print(element.getCondition(), writer);
        writer.append(")\n");
        this.statementPrinter.print(element.getStatement(), writer);
        if (element.getElseStatement() != null) {
            writer.append("else\n");
            this.statementPrinter.print(element.getElseStatement(), writer);
        }
    }
}

