/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.generics.TypeParametrizable;
import tools.mdsd.jamopp.model.java.members.MemberContainer;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class InterfacePrinterImpl
implements Printer<Interface> {
    private final Printer<AnnotableAndModifiable> annotableAndModifiablePrinter;
    private final Printer<MemberContainer> memberContainerPrinter;
    private final Printer<TypeParametrizable> typeParametrizablePrinter;
    private final Printer<TypeReference> typeReferencePrinter;

    @Inject
    public InterfacePrinterImpl(Printer<AnnotableAndModifiable> annotableAndModifiablePrinter, Printer<TypeParametrizable> typeParametrizablePrinter, Printer<TypeReference> typeReferencePrinter, Printer<MemberContainer> memberContainerPrinter) {
        this.annotableAndModifiablePrinter = annotableAndModifiablePrinter;
        this.typeParametrizablePrinter = typeParametrizablePrinter;
        this.typeReferencePrinter = typeReferencePrinter;
        this.memberContainerPrinter = memberContainerPrinter;
    }

    @Override
    public void print(Interface element, BufferedWriter writer) throws IOException {
        this.annotableAndModifiablePrinter.print((AnnotableAndModifiable)element, writer);
        writer.append("interface " + element.getName());
        this.typeParametrizablePrinter.print((TypeParametrizable)element, writer);
        writer.append(" ");
        if (!element.getExtends().isEmpty()) {
            writer.append("extends ");
            this.typeReferencePrinter.print((TypeReference)element.getExtends().get(0), writer);
            int index = 1;
            while (index < element.getExtends().size()) {
                writer.append(", ");
                this.typeReferencePrinter.print((TypeReference)element.getExtends().get(index), writer);
                ++index;
            }
            writer.append(" ");
        }
        writer.append("{\n");
        this.memberContainerPrinter.print((MemberContainer)element, writer);
        writer.append("}\n");
    }
}

