/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import tools.mdsd.jamopp.model.java.annotations.Annotable;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.imports.ImportingElement;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class JavaRootPrinterImpl
implements Printer<JavaRoot> {
    private final Printer<Annotable> annotablePrinter;
    private final Printer<CompilationUnit> compilationUnitPrinter;
    private final Printer<ImportingElement> importingElementPrinter;
    private final Printer<Module> modulePrinter;

    @Inject
    public JavaRootPrinterImpl(Printer<ImportingElement> importingElementPrinter, Printer<Module> modulePrinter, Printer<Annotable> annotablePrinter, Printer<CompilationUnit> compilationUnitPrinter) {
        this.importingElementPrinter = importingElementPrinter;
        this.modulePrinter = modulePrinter;
        this.annotablePrinter = annotablePrinter;
        this.compilationUnitPrinter = compilationUnitPrinter;
    }

    @Override
    public void print(JavaRoot root, BufferedWriter writer) throws IOException {
        if (root instanceof Module) {
            this.importingElementPrinter.print((ImportingElement)root, writer);
            this.modulePrinter.print((Module)root, writer);
        } else {
            if (!root.getNamespaces().isEmpty()) {
                this.annotablePrinter.print((Annotable)root, writer);
                writer.append("package " + root.getNamespacesAsString() + ";\n\n");
            }
            this.importingElementPrinter.print((ImportingElement)root, writer);
            if (root instanceof CompilationUnit) {
                this.compilationUnitPrinter.print((CompilationUnit)root, writer);
            }
        }
    }
}

