/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import tools.mdsd.jamopp.model.java.expressions.ImplicitlyTypedLambdaParameters;
import tools.mdsd.jamopp.model.java.expressions.LambdaParameters;
import tools.mdsd.jamopp.model.java.expressions.SingleImplicitLambdaParameter;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class LambdaParametersPrinterImpl
implements Printer<LambdaParameters> {
    private final Printer<OrdinaryParameter> ordinaryParameterPrinter;
    private final Printer<VariableLengthParameter> variableLengthParameterPrinter;

    @Inject
    public LambdaParametersPrinterImpl(Printer<OrdinaryParameter> ordinaryParameterPrinter, Printer<VariableLengthParameter> variableLengthParameterPrinter) {
        this.ordinaryParameterPrinter = ordinaryParameterPrinter;
        this.variableLengthParameterPrinter = variableLengthParameterPrinter;
    }

    @Override
    public void print(LambdaParameters element, BufferedWriter writer) throws IOException {
        if (element instanceof SingleImplicitLambdaParameter) {
            this.handleSingleImplicitLambdaParameter(element, writer);
        } else if (element instanceof ImplicitlyTypedLambdaParameters) {
            this.handleImplicitlyTypedLambdaParameters(element, writer);
        } else {
            this.handleOther(element, writer);
        }
    }

    private void handleSingleImplicitLambdaParameter(LambdaParameters element, BufferedWriter writer) throws IOException {
        writer.append(((Parameter)element.getParameters().get(0)).getName());
    }

    private void handleOther(LambdaParameters element, BufferedWriter writer) throws IOException {
        writer.append("(");
        int index = 0;
        while (index < element.getParameters().size()) {
            Parameter param = (Parameter)element.getParameters().get(index);
            if (param instanceof OrdinaryParameter) {
                this.ordinaryParameterPrinter.print((OrdinaryParameter)param, writer);
            } else {
                this.variableLengthParameterPrinter.print((VariableLengthParameter)param, writer);
            }
            if (index < element.getParameters().size() - 1) {
                writer.append(", ");
            }
            ++index;
        }
        writer.append(")");
    }

    private void handleImplicitlyTypedLambdaParameters(LambdaParameters element, BufferedWriter writer) throws IOException {
        writer.append("(");
        int index = 0;
        while (index < element.getParameters().size()) {
            writer.append(((Parameter)element.getParameters().get(index)).getName());
            if (index < element.getParameters().size() - 1) {
                writer.append(", ");
            }
            ++index;
        }
        writer.append(")");
    }
}

