/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import tools.mdsd.jamopp.model.java.literals.BinaryIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.BinaryLongLiteral;
import tools.mdsd.jamopp.model.java.literals.BooleanLiteral;
import tools.mdsd.jamopp.model.java.literals.CharacterLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalDoubleLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalFloatLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalLongLiteral;
import tools.mdsd.jamopp.model.java.literals.HexDoubleLiteral;
import tools.mdsd.jamopp.model.java.literals.HexFloatLiteral;
import tools.mdsd.jamopp.model.java.literals.HexIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.HexLongLiteral;
import tools.mdsd.jamopp.model.java.literals.Literal;
import tools.mdsd.jamopp.model.java.literals.NullLiteral;
import tools.mdsd.jamopp.model.java.literals.OctalIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.OctalLongLiteral;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class LiteralPrinterImpl
implements Printer<Literal> {
    private final List<Mapping<?>> mappings = new ArrayList();

    @Inject
    public LiteralPrinterImpl() {
        this.mappings.add(new Mapping<BooleanLiteral>(BooleanLiteral.class, lit -> Boolean.toString(lit.isValue())));
        this.mappings.add(new Mapping<CharacterLiteral>(CharacterLiteral.class, lit -> "'" + lit.getValue() + "'"));
        this.mappings.add(new Mapping<NullLiteral>(NullLiteral.class, lit -> "null"));
        this.mappings.add(new Mapping<DecimalFloatLiteral>(DecimalFloatLiteral.class, lit -> String.valueOf(Float.toString(lit.getDecimalValue())) + "F"));
        this.mappings.add(new Mapping<HexFloatLiteral>(HexFloatLiteral.class, lit -> String.valueOf(Float.toHexString(lit.getHexValue())) + "F"));
        this.mappings.add(new Mapping<DecimalDoubleLiteral>(DecimalDoubleLiteral.class, lit -> String.valueOf(Double.toString(lit.getDecimalValue())) + "D"));
        this.mappings.add(new Mapping<HexDoubleLiteral>(HexDoubleLiteral.class, lit -> String.valueOf(Double.toHexString(lit.getHexValue())) + "D"));
        this.mappings.add(new Mapping<DecimalIntegerLiteral>(DecimalIntegerLiteral.class, lit -> lit.getDecimalValue().toString()));
        this.mappings.add(new Mapping<HexIntegerLiteral>(HexIntegerLiteral.class, lit -> "0x" + lit.getHexValue().toString(16)));
        this.mappings.add(new Mapping<OctalIntegerLiteral>(OctalIntegerLiteral.class, lit -> "0" + lit.getOctalValue().toString(8)));
        this.mappings.add(new Mapping<BinaryIntegerLiteral>(BinaryIntegerLiteral.class, lit -> "0b" + lit.getBinaryValue().toString(2)));
        this.mappings.add(new Mapping<DecimalLongLiteral>(DecimalLongLiteral.class, lit -> String.valueOf(lit.getDecimalValue().toString()) + "L"));
        this.mappings.add(new Mapping<HexLongLiteral>(HexLongLiteral.class, lit -> "0x" + lit.getHexValue().toString(16) + "L"));
        this.mappings.add(new Mapping<OctalLongLiteral>(OctalLongLiteral.class, lit -> "0" + lit.getOctalValue().toString(8) + "L"));
        this.mappings.add(new Mapping<BinaryLongLiteral>(BinaryLongLiteral.class, lit -> "0b" + lit.getBinaryValue().toString(2) + "L"));
    }

    @Override
    public void print(Literal element, BufferedWriter writer) throws IOException {
        for (Mapping<?> pair : this.mappings) {
            if (!pair.getClazz().isInstance(element)) continue;
            writer.append(pair.convert(element));
            return;
        }
    }

    private static class Mapping<K extends Literal> {
        private final Class<K> clazz;
        private final Function<K, String> fun;

        private Mapping(Class<K> clazz, Function<K, String> fun) {
            this.clazz = clazz;
            this.fun = fun;
        }

        private Class<K> getClazz() {
            return this.clazz;
        }

        private String convert(Literal literal) {
            return this.fun.apply((Literal)this.clazz.cast(literal));
        }
    }
}

