/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import tools.mdsd.jamopp.model.java.arrays.ArrayDimension;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.generics.TypeArgumentable;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.variables.AdditionalLocalVariable;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class LocalVariablePrinterImpl
implements Printer<LocalVariable> {
    private final Printer<AdditionalLocalVariable> additionalLocalVariablePrinter;
    private final Printer<AnnotableAndModifiable> annotableAndModifiablePrinter;
    private final Printer<List<ArrayDimension>> arrayDimensionsPrinter;
    private final Printer<Expression> expressionPrinter;
    private final Printer<TypeArgumentable> typeArgumentablePrinter;
    private final Printer<TypeReference> typeReferencePrinter;

    @Inject
    public LocalVariablePrinterImpl(Printer<AnnotableAndModifiable> annotableAndModifiablePrinter, Printer<TypeReference> typeReferencePrinter, Printer<TypeArgumentable> typeArgumentablePrinter, Printer<List<ArrayDimension>> arrayDimensionsPrinter, Printer<Expression> expressionPrinter, Printer<AdditionalLocalVariable> additionalLocalVariablePrinter) {
        this.annotableAndModifiablePrinter = annotableAndModifiablePrinter;
        this.typeReferencePrinter = typeReferencePrinter;
        this.typeArgumentablePrinter = typeArgumentablePrinter;
        this.arrayDimensionsPrinter = arrayDimensionsPrinter;
        this.expressionPrinter = expressionPrinter;
        this.additionalLocalVariablePrinter = additionalLocalVariablePrinter;
    }

    @Override
    public void print(LocalVariable element, BufferedWriter writer) throws IOException {
        this.annotableAndModifiablePrinter.print((AnnotableAndModifiable)element, writer);
        this.typeReferencePrinter.print(element.getTypeReference(), writer);
        this.typeArgumentablePrinter.print((TypeArgumentable)element, writer);
        this.arrayDimensionsPrinter.print((List<ArrayDimension>)element.getArrayDimensionsBefore(), writer);
        writer.append(" " + element.getName());
        this.arrayDimensionsPrinter.print((List<ArrayDimension>)element.getArrayDimensionsAfter(), writer);
        if (element.getInitialValue() != null) {
            writer.append(" = ");
            this.expressionPrinter.print(element.getInitialValue(), writer);
        }
        for (AdditionalLocalVariable variable : element.getAdditionalLocalVariables()) {
            writer.append(", ");
            this.additionalLocalVariablePrinter.print(variable, writer);
        }
    }
}

