/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import tools.mdsd.jamopp.model.java.annotations.Annotable;
import tools.mdsd.jamopp.model.java.types.Boolean;
import tools.mdsd.jamopp.model.java.types.Byte;
import tools.mdsd.jamopp.model.java.types.Char;
import tools.mdsd.jamopp.model.java.types.Double;
import tools.mdsd.jamopp.model.java.types.Float;
import tools.mdsd.jamopp.model.java.types.Int;
import tools.mdsd.jamopp.model.java.types.Long;
import tools.mdsd.jamopp.model.java.types.PrimitiveType;
import tools.mdsd.jamopp.model.java.types.Short;
import tools.mdsd.jamopp.model.java.types.Void;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class PrimitiveTypePrinterImpl
implements Printer<PrimitiveType> {
    private final Printer<Annotable> annotablePrinter;
    private final Map<Class<?>, String> mappings;

    @Inject
    public PrimitiveTypePrinterImpl(Printer<Annotable> annotablePrinter) {
        this.annotablePrinter = annotablePrinter;
        this.mappings = new HashMap();
        this.mappings.put(Boolean.class, "boolean");
        this.mappings.put(Byte.class, "byte");
        this.mappings.put(Char.class, "char");
        this.mappings.put(Double.class, "double");
        this.mappings.put(Float.class, "float");
        this.mappings.put(Int.class, "int");
        this.mappings.put(Long.class, "long");
        this.mappings.put(Short.class, "short");
        this.mappings.put(Void.class, "void");
    }

    @Override
    public void print(PrimitiveType element, BufferedWriter writer) throws IOException {
        this.annotablePrinter.print((Annotable)element, writer);
        for (Map.Entry<Class<?>, String> entry : this.mappings.entrySet()) {
            Class<?> key = entry.getKey();
            String val = entry.getValue();
            if (!key.isInstance(element)) continue;
            writer.append(val);
            break;
        }
    }
}

