/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import tools.mdsd.jamopp.model.java.annotations.Annotable;
import tools.mdsd.jamopp.model.java.generics.TypeArgumentable;
import tools.mdsd.jamopp.model.java.parameters.ReceiverParameter;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class ReceiverParameterPrinterImpl
implements Printer<ReceiverParameter> {
    private final Printer<Annotable> annotablePrinter;
    private final Printer<TypeArgumentable> typeArgumentablePrinter;
    private final Printer<TypeReference> typeReferencePrinter;

    @Inject
    public ReceiverParameterPrinterImpl(Printer<Annotable> annotablePrinter, Printer<TypeReference> typeReferencePrinter, Printer<TypeArgumentable> typeArgumentablePrinter) {
        this.annotablePrinter = annotablePrinter;
        this.typeReferencePrinter = typeReferencePrinter;
        this.typeArgumentablePrinter = typeArgumentablePrinter;
    }

    @Override
    public void print(ReceiverParameter element, BufferedWriter writer) throws IOException {
        this.annotablePrinter.print((Annotable)element, writer);
        this.typeReferencePrinter.print(element.getTypeReference(), writer);
        this.typeArgumentablePrinter.print((TypeArgumentable)element, writer);
        writer.append(" ");
        if (element.getOuterTypeReference() != null) {
            this.typeReferencePrinter.print(element.getOuterTypeReference(), writer);
            writer.append(".");
        }
        writer.append("this");
    }
}

