/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.arrays.ArrayInstantiation;
import tools.mdsd.jamopp.model.java.arrays.ArraySelector;
import tools.mdsd.jamopp.model.java.expressions.NestedExpression;
import tools.mdsd.jamopp.model.java.instantiations.Instantiation;
import tools.mdsd.jamopp.model.java.references.ElementReference;
import tools.mdsd.jamopp.model.java.references.PrimitiveTypeReference;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReflectiveClassReference;
import tools.mdsd.jamopp.model.java.references.SelfReference;
import tools.mdsd.jamopp.model.java.references.StringReference;
import tools.mdsd.jamopp.model.java.references.TextBlockReference;
import tools.mdsd.jamopp.printer.implementation.Mapping;
import tools.mdsd.jamopp.printer.interfaces.EmptyPrinter;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class ReferencePrinterImpl
implements Printer<Reference> {
    private final Printer<AnnotationInstance> annotationInstancePrinter;
    private final Printer<ArrayInstantiation> arrayInstantiationPrinter;
    private final Printer<ArraySelector> arraySelectorPrinter;
    private final Printer<ElementReference> elementReferencePrinter;
    private final Printer<Instantiation> instantiationPrinter;
    private final Printer<NestedExpression> nestedExpressionPrinter;
    private final Printer<PrimitiveTypeReference> primitiveTypeReferencePrinter;
    private final EmptyPrinter reflectiveClassReferencePrinter;
    private final Printer<SelfReference> selfReferencePrinter;
    private final Printer<StringReference> stringReferencePrinter;
    private final Printer<TextBlockReference> textBlockReferencePrinter;
    private final List<Mapping<?>> mappings;

    @Inject
    public ReferencePrinterImpl(Printer<AnnotationInstance> annotationInstancePrinter, Printer<NestedExpression> nestedExpressionPrinter, @Named(value="ReflectiveClassReferencePrinter") EmptyPrinter reflectiveClassReferencePrinter, Printer<PrimitiveTypeReference> primitiveTypeReferencePrinter, Printer<StringReference> stringReferencePrinter, Printer<SelfReference> selfReferencePrinter, Printer<ArrayInstantiation> arrayInstantiationPrinter, Printer<Instantiation> instantiationPrinter, Printer<TextBlockReference> textBlockReferencePrinter, Printer<ElementReference> elementReferencePrinter, Printer<ArraySelector> arraySelectorPrinter) {
        this.annotationInstancePrinter = annotationInstancePrinter;
        this.nestedExpressionPrinter = nestedExpressionPrinter;
        this.reflectiveClassReferencePrinter = reflectiveClassReferencePrinter;
        this.primitiveTypeReferencePrinter = primitiveTypeReferencePrinter;
        this.stringReferencePrinter = stringReferencePrinter;
        this.selfReferencePrinter = selfReferencePrinter;
        this.arrayInstantiationPrinter = arrayInstantiationPrinter;
        this.instantiationPrinter = instantiationPrinter;
        this.textBlockReferencePrinter = textBlockReferencePrinter;
        this.elementReferencePrinter = elementReferencePrinter;
        this.arraySelectorPrinter = arraySelectorPrinter;
        this.mappings = new ArrayList();
    }

    @Override
    public void print(Reference element, BufferedWriter writer) throws IOException {
        if (this.mappings.isEmpty()) {
            this.mappings.add(new Mapping<AnnotationInstance>(AnnotationInstance.class, this.annotationInstancePrinter));
            this.mappings.add(new Mapping<NestedExpression>(NestedExpression.class, this.nestedExpressionPrinter));
            this.mappings.add(new Mapping<PrimitiveTypeReference>(PrimitiveTypeReference.class, this.primitiveTypeReferencePrinter));
            this.mappings.add(new Mapping<StringReference>(StringReference.class, this.stringReferencePrinter));
            this.mappings.add(new Mapping<SelfReference>(SelfReference.class, this.selfReferencePrinter));
            this.mappings.add(new Mapping<ArrayInstantiation>(ArrayInstantiation.class, this.arrayInstantiationPrinter));
            this.mappings.add(new Mapping<Instantiation>(Instantiation.class, this.instantiationPrinter));
            this.mappings.add(new Mapping<TextBlockReference>(TextBlockReference.class, this.textBlockReferencePrinter));
            this.mappings.add(new Mapping<ElementReference>(ElementReference.class, this.elementReferencePrinter));
        }
        boolean printed = false;
        for (Mapping<?> mapping : this.mappings) {
            printed = mapping.checkAndPrint((EObject)element, writer);
            if (printed) break;
        }
        if (element instanceof ReflectiveClassReference && !printed) {
            this.reflectiveClassReferencePrinter.print(writer);
        }
        for (ArraySelector sel : element.getArraySelectors()) {
            this.arraySelectorPrinter.print(sel, writer);
        }
        if (element.getNext() != null) {
            writer.append(".");
            this.print(element.getNext(), writer);
        }
    }
}

