/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.statements.Assert;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.model.java.statements.Break;
import tools.mdsd.jamopp.model.java.statements.Condition;
import tools.mdsd.jamopp.model.java.statements.Continue;
import tools.mdsd.jamopp.model.java.statements.DoWhileLoop;
import tools.mdsd.jamopp.model.java.statements.EmptyStatement;
import tools.mdsd.jamopp.model.java.statements.ExpressionStatement;
import tools.mdsd.jamopp.model.java.statements.ForEachLoop;
import tools.mdsd.jamopp.model.java.statements.ForLoop;
import tools.mdsd.jamopp.model.java.statements.JumpLabel;
import tools.mdsd.jamopp.model.java.statements.LocalVariableStatement;
import tools.mdsd.jamopp.model.java.statements.Return;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.Switch;
import tools.mdsd.jamopp.model.java.statements.SynchronizedBlock;
import tools.mdsd.jamopp.model.java.statements.Throw;
import tools.mdsd.jamopp.model.java.statements.TryBlock;
import tools.mdsd.jamopp.model.java.statements.WhileLoop;
import tools.mdsd.jamopp.model.java.statements.YieldStatement;
import tools.mdsd.jamopp.printer.implementation.Mapping;
import tools.mdsd.jamopp.printer.interfaces.EmptyPrinter;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class StatementPrinterImpl
implements Printer<Statement> {
    private final Provider<Printer<Assert>> assertPrinter;
    private final Provider<Printer<Block>> blockPrinter;
    private final Provider<Printer<Break>> breakPrinter;
    private final Provider<Printer<ConcreteClassifier>> concreteClassifierPrinter;
    private final Provider<Printer<Condition>> conditionPrinter;
    private final Provider<Printer<Continue>> continuePrinter;
    private final Provider<Printer<DoWhileLoop>> doWhileLoopPrinter;
    private final Provider<EmptyPrinter> emptyStatementPrinter;
    private final Provider<Printer<ExpressionStatement>> expressionStatementPrinter;
    private final Provider<Printer<ForEachLoop>> forEachLoopPrinter;
    private final Provider<Printer<ForLoop>> forLoopPrinter;
    private final Provider<Printer<JumpLabel>> jumpLabelPrinter;
    private final Provider<Printer<LocalVariableStatement>> localVariableStatementPrinter;
    private final Provider<Printer<Return>> returnPrinter;
    private final Provider<Printer<Switch>> switchPrinter;
    private final Provider<Printer<SynchronizedBlock>> synchronizedBlockPrinter;
    private final Provider<Printer<Throw>> throwPrinter;
    private final Provider<Printer<TryBlock>> tryBlockPrinter;
    private final Provider<Printer<WhileLoop>> whileLoopPrinter;
    private final Provider<Printer<YieldStatement>> yieldStatementPrinter;
    private final List<Mapping<? extends Statement>> mappings;

    @Inject
    public StatementPrinterImpl(Provider<Printer<ConcreteClassifier>> concreteClassifierPrinter, Provider<Printer<Assert>> assertPrinter, Provider<Printer<Block>> blockPrinter, Provider<Printer<Condition>> conditionPrinter, @Named(value="EmptyStatementPrinter") Provider<EmptyPrinter> emptyStatementPrinter, Provider<Printer<ExpressionStatement>> expressionStatementPrinter, Provider<Printer<ForLoop>> forLoopPrinter, Provider<Printer<ForEachLoop>> forEachLoopPrinter, Provider<Printer<Break>> breakPrinter, Provider<Printer<Continue>> continuePrinter, Provider<Printer<JumpLabel>> jumpLabelPrinter, Provider<Printer<LocalVariableStatement>> localVariableStatementPrinter, Provider<Printer<Return>> returnPrinter, Provider<Printer<Switch>> switchPrinter, Provider<Printer<SynchronizedBlock>> synchronizedBlockPrinter, Provider<Printer<Throw>> throwPrinter, Provider<Printer<TryBlock>> tryBlockPrinter, Provider<Printer<DoWhileLoop>> doWhileLoopPrinter, Provider<Printer<WhileLoop>> whileLoopPrinter, Provider<Printer<YieldStatement>> yieldStatementPrinter) {
        this.concreteClassifierPrinter = concreteClassifierPrinter;
        this.assertPrinter = assertPrinter;
        this.blockPrinter = blockPrinter;
        this.conditionPrinter = conditionPrinter;
        this.emptyStatementPrinter = emptyStatementPrinter;
        this.expressionStatementPrinter = expressionStatementPrinter;
        this.forLoopPrinter = forLoopPrinter;
        this.forEachLoopPrinter = forEachLoopPrinter;
        this.breakPrinter = breakPrinter;
        this.continuePrinter = continuePrinter;
        this.jumpLabelPrinter = jumpLabelPrinter;
        this.localVariableStatementPrinter = localVariableStatementPrinter;
        this.returnPrinter = returnPrinter;
        this.switchPrinter = switchPrinter;
        this.synchronizedBlockPrinter = synchronizedBlockPrinter;
        this.throwPrinter = throwPrinter;
        this.tryBlockPrinter = tryBlockPrinter;
        this.doWhileLoopPrinter = doWhileLoopPrinter;
        this.whileLoopPrinter = whileLoopPrinter;
        this.yieldStatementPrinter = yieldStatementPrinter;
        this.mappings = new ArrayList<Mapping<? extends Statement>>();
    }

    @Override
    public void print(Statement element, BufferedWriter writer) throws IOException {
        if (this.mappings.isEmpty()) {
            this.mappings.add(new Mapping<ConcreteClassifier>(ConcreteClassifier.class, (Printer)this.concreteClassifierPrinter.get()));
            this.mappings.add(new Mapping<Assert>(Assert.class, (Printer)this.assertPrinter.get()));
            this.mappings.add(new Mapping<Block>(Block.class, (Printer)this.blockPrinter.get()));
            this.mappings.add(new Mapping<Condition>(Condition.class, (Printer)this.conditionPrinter.get()));
            this.mappings.add(new Mapping<ExpressionStatement>(ExpressionStatement.class, (Printer)this.expressionStatementPrinter.get()));
            this.mappings.add(new Mapping<ForLoop>(ForLoop.class, (Printer)this.forLoopPrinter.get()));
            this.mappings.add(new Mapping<ForEachLoop>(ForEachLoop.class, (Printer)this.forEachLoopPrinter.get()));
            this.mappings.add(new Mapping<Break>(Break.class, (Printer)this.breakPrinter.get()));
            this.mappings.add(new Mapping<Continue>(Continue.class, (Printer)this.continuePrinter.get()));
            this.mappings.add(new Mapping<JumpLabel>(JumpLabel.class, (Printer)this.jumpLabelPrinter.get()));
            this.mappings.add(new Mapping<LocalVariableStatement>(LocalVariableStatement.class, (Printer)this.localVariableStatementPrinter.get()));
            this.mappings.add(new Mapping<Return>(Return.class, (Printer)this.returnPrinter.get()));
            this.mappings.add(new Mapping<Switch>(Switch.class, (Printer)this.switchPrinter.get()));
            this.mappings.add(new Mapping<SynchronizedBlock>(SynchronizedBlock.class, (Printer)this.synchronizedBlockPrinter.get()));
            this.mappings.add(new Mapping<Throw>(Throw.class, (Printer)this.throwPrinter.get()));
            this.mappings.add(new Mapping<TryBlock>(TryBlock.class, (Printer)this.tryBlockPrinter.get()));
            this.mappings.add(new Mapping<DoWhileLoop>(DoWhileLoop.class, (Printer)this.doWhileLoopPrinter.get()));
            this.mappings.add(new Mapping<WhileLoop>(WhileLoop.class, (Printer)this.whileLoopPrinter.get()));
            this.mappings.add(new Mapping<YieldStatement>(YieldStatement.class, (Printer)this.yieldStatementPrinter.get()));
        }
        for (Mapping<? extends Statement> mapping : this.mappings) {
            boolean printed = mapping.checkAndPrint((EObject)element, writer);
            if (!printed) continue;
            return;
        }
        if (element instanceof EmptyStatement) {
            ((EmptyPrinter)this.emptyStatementPrinter.get()).print(writer);
        }
    }
}

