/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer.implementation;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import javax.inject.Provider;
import tools.mdsd.jamopp.model.java.annotations.Annotable;
import tools.mdsd.jamopp.model.java.arrays.ArrayDimension;
import tools.mdsd.jamopp.model.java.generics.ExtendsTypeArgument;
import tools.mdsd.jamopp.model.java.generics.QualifiedTypeArgument;
import tools.mdsd.jamopp.model.java.generics.SuperTypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.generics.UnknownTypeArgument;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.printer.interfaces.Printer;

public class TypeArgumentPrinterImpl
implements Printer<TypeArgument> {
    private final Printer<Annotable> annotablePrinter;
    private final Printer<List<ArrayDimension>> arrayDimensionsPrinter;
    private final Provider<Printer<TypeReference>> typeReferencePrinter;

    @Inject
    public TypeArgumentPrinterImpl(Provider<Printer<TypeReference>> typeReferencePrinter, Printer<Annotable> annotablePrinter, Printer<List<ArrayDimension>> arrayDimensionsPrinter) {
        this.typeReferencePrinter = typeReferencePrinter;
        this.annotablePrinter = annotablePrinter;
        this.arrayDimensionsPrinter = arrayDimensionsPrinter;
    }

    @Override
    public void print(TypeArgument element, BufferedWriter writer) throws IOException {
        if (element instanceof QualifiedTypeArgument var3_4) {
            ((Printer)this.typeReferencePrinter.get()).print(arg.getTypeReference(), writer);
        } else {
            if (element instanceof UnknownTypeArgument var5_6) {
                this.annotablePrinter.print((Annotable)arg, writer);
                writer.append("?");
            } else {
                if (element instanceof SuperTypeArgument var7_8) {
                    this.annotablePrinter.print((Annotable)arg, writer);
                    writer.append("? super ");
                    ((Printer)this.typeReferencePrinter.get()).print(arg.getSuperType(), writer);
                } else {
                    ExtendsTypeArgument arg = (ExtendsTypeArgument)element;
                    this.annotablePrinter.print((Annotable)arg, writer);
                    writer.append("? extends ");
                    ((Printer)this.typeReferencePrinter.get()).print(arg.getExtendType(), writer);
                }
            }
        }
        this.arrayDimensionsPrinter.print((List<ArrayDimension>)element.getArrayDimensionsBefore(), writer);
        this.arrayDimensionsPrinter.print((List<ArrayDimension>)element.getArrayDimensionsAfter(), writer);
    }
}

