/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.standalone;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.ContainersFactory;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.parser.JaMoPPJDTParser;
import tools.mdsd.jamopp.resource.JavaResource2Factory;

public final class JaMoPPStandalone {
    private static final PrintStream OUTPUT = System.out;
    private static final String INPUT = "";
    private static final boolean ENABLE_OUTPUT_OF_LIBRARY_FILES = false;

    private JaMoPPStandalone() {
    }

    public static void main(String[] agrs) {
        ContainersFactory.eINSTANCE.createEmptyModel();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("java", new JavaResource2Factory());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        JaMoPPJDTParser parser = new JaMoPPJDTParser();
        ResourceSet resourceSet = parser.parseUri(URI.createURI((String)INPUT));
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        for (Resource javaResource : new ArrayList(resourceSet.getResources())) {
            if (javaResource.getContents().isEmpty()) {
                OUTPUT.println("WARNING: Emtpy Resource: " + javaResource.getURI());
                continue;
            }
            if (!"file".equals(javaResource.getURI().scheme())) continue;
            File outputFile = JaMoPPStandalone.createFile(javaResource);
            outputFile.getParentFile().mkdirs();
            URI xmiFileURI = URI.createFileURI((String)outputFile.getAbsolutePath()).appendFileExtension("xmi");
            Resource xmiResource = resourceSet.createResource(xmiFileURI);
            xmiResource.getContents().addAll((Collection)javaResource.getContents());
        }
        for (Resource xmiResource : resourceSet.getResources()) {
            if (!(xmiResource instanceof XMIResource)) continue;
            try {
                xmiResource.save(resourceSet.getLoadOptions());
            }
            catch (IOException iOException) {}
        }
    }

    private static File createFile(Resource javaResource) {
        return new File("." + File.separator + "./standalone_output" + File.separator + JaMoPPStandalone.checkScheme(javaResource));
    }

    private static String checkScheme(Resource javaResource) {
        StringBuilder outputFileName = null;
        JavaRoot root = (JavaRoot)javaResource.getContents().get(0);
        String nameSpace = root.getNamespacesAsString().replace(".", File.separator);
        if (root instanceof CompilationUnit) {
            outputFileName = new StringBuilder(String.valueOf(nameSpace) + File.separator);
            CompilationUnit compilationUnit = (CompilationUnit)root;
            if (compilationUnit.getClassifiers().isEmpty()) {
                outputFileName.append(0);
            } else {
                outputFileName.append(((ConcreteClassifier)compilationUnit.getClassifiers().get(0)).getName());
            }
        } else if (root instanceof Package) {
            outputFileName = new StringBuilder(nameSpace).append(File.separator).append("package-info");
            if (outputFileName.toString().startsWith(File.separator)) {
                outputFileName = new StringBuilder(outputFileName.substring(1));
            }
        } else if (root instanceof Module) {
            outputFileName = new StringBuilder(nameSpace).append(File.separator).append("module-info");
        }
        if (outputFileName == null) {
            outputFileName = new StringBuilder();
        }
        return outputFileName.toString();
    }
}

