/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.library.emfeditutils.itempropertydescriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.library.emfeditutils.itempropertydescriptor.ValueChoiceCalculator;

public abstract class ValueChoiceCalculatorBase<T extends EObject, R>
implements ValueChoiceCalculator {
    private final Class<T> objectType;
    private final Class<R> childType;

    public ValueChoiceCalculatorBase(Class<T> objectType, Class<R> childType) {
        this.objectType = objectType;
        this.childType = childType;
    }

    @Override
    public Collection<?> getValueChoice(Object object, Collection<?> originalChoice) {
        Optional<EObject> typedObject = Optional.ofNullable(object).filter(this.objectType::isInstance).map(this.objectType::cast);
        if (typedObject.isEmpty()) {
            return originalChoice;
        }
        if (originalChoice == null) {
            originalChoice = new ArrayList();
        }
        List typedList = originalChoice.stream().filter(v -> v == null || this.childType.isInstance(v)).map(this.childType::cast).collect(Collectors.toList());
        Collection<?> newChoice = this.getValueChoiceTyped(typedObject.get(), typedList);
        if (originalChoice.contains(null) && !newChoice.contains(null)) {
            ArrayList newChoiceCopy = new ArrayList(newChoice);
            newChoiceCopy.add(0, null);
            newChoice = newChoiceCopy;
        }
        return newChoice;
    }

    protected abstract Collection<?> getValueChoiceTyped(T var1, List<R> var2);
}

