/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.processor;

import java.util.Set;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;
import tools.mdsd.mocore.framework.processor.Processor;
import tools.mdsd.mocore.framework.surrogate.Model;
import tools.mdsd.mocore.framework.surrogate.Replaceable;

public abstract class ProcessorTest<U extends Processor<M, T>, M extends Model, T extends Replaceable> {
    protected static final String TEST_API_ONLY_METHOD_NAME = "testApiOnly";
    private static final boolean TEST_API_ONLY = true;

    @Test
    public void testGetModelAfterCreation() {
        M model = this.createEmptyModel();
        U processor = this.createProcessor(model);
        Assert.assertNotNull((Object)processor.getModel());
        Assert.assertEquals(model, (Object)processor.getModel());
    }

    @Test
    public void testGetImplicationsAfterCreation() {
        M model = this.createEmptyModel();
        U processor = this.createProcessor(model);
        Set implications = processor.getImplications();
        Assert.assertNotNull((Object)implications);
        Assert.assertTrue((boolean)implications.isEmpty());
    }

    @Test
    public void testGetProcessableType() {
        M model = this.createEmptyModel();
        U processor = this.createProcessor(model);
        T replaceable = this.createUniqueReplaceable();
        Assert.assertEquals(replaceable.getClass(), (Object)processor.getProcessableType());
    }

    @Test
    @DisabledIf(value="testApiOnly")
    public void testMergeAddsReplaceableToModel() {
        M model = this.createEmptyModel();
        U processor = this.createProcessor(model);
        T replaceable = this.createUniqueReplaceable();
        Assert.assertFalse((boolean)model.contains(replaceable));
        processor.merge(replaceable);
        Assert.assertTrue((boolean)model.contains(replaceable));
    }

    @Test
    public void testProcessExecutesMerge() {
        M model = this.createEmptyModel();
        U processor = this.createProcessor(model);
        T replaceable = this.createUniqueReplaceable();
        Assert.assertFalse((boolean)model.contains(replaceable));
        processor.process(replaceable);
        Assert.assertTrue((boolean)model.contains(replaceable));
    }

    @Test
    @DisabledIf(value="testApiOnly")
    public void testProcessClearsImplications() {
        M model = this.createEmptyModel();
        U processor = this.createProcessor(model);
        T replaceable = this.createUniqueReplaceable();
        processor.addImplication(replaceable);
        Assert.assertTrue((boolean)processor.getImplications().contains(replaceable));
        Assert.assertFalse((boolean)processor.getImplications().isEmpty());
        processor.process(replaceable);
        Set implications = processor.getImplications();
        Assert.assertFalse((boolean)implications.contains(replaceable));
    }

    protected abstract U createProcessor(M var1);

    protected abstract M createEmptyModel();

    protected abstract T createUniqueReplaceable();

    protected static boolean testApiOnly() {
        return true;
    }
}

