/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.processor;

import java.util.Set;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;
import tools.mdsd.mocore.framework.processor.ProcessorTest;
import tools.mdsd.mocore.framework.processor.RelationProcessor;
import tools.mdsd.mocore.framework.surrogate.Model;
import tools.mdsd.mocore.framework.surrogate.Relation;
import tools.mdsd.mocore.framework.surrogate.Replaceable;

public abstract class RelationProcessorTest<RP extends RelationProcessor<M, R>, M extends Model, R extends Relation<T, S>, T extends Replaceable, S extends Replaceable>
extends ProcessorTest<RP, M, R> {
    @Test
    public void testProcessAddsSourceAndDestinationToImplications() {
        Object model = this.createEmptyModel();
        RelationProcessor processor = (RelationProcessor)this.createProcessor(model);
        T source = this.getUniqueNonPlaceholderSourceEntity();
        S destination = this.getUniqueNonPlaceholderDestinationEntity();
        R relation = this.createRelation(source, destination, false);
        Assert.assertFalse((boolean)model.contains(source));
        Assert.assertFalse((boolean)model.contains(destination));
        Assert.assertFalse((boolean)model.contains(relation));
        Assert.assertFalse((boolean)processor.getImplications().contains(source));
        Assert.assertFalse((boolean)processor.getImplications().contains(destination));
        Assert.assertFalse((boolean)processor.getImplications().contains(relation));
        processor.process(relation);
        Assert.assertFalse((boolean)model.contains(source));
        Assert.assertFalse((boolean)model.contains(destination));
        Assert.assertTrue((boolean)model.contains(relation));
        Assert.assertTrue((boolean)processor.getImplications().contains(source));
        Assert.assertTrue((boolean)processor.getImplications().contains(destination));
        Assert.assertFalse((boolean)processor.getImplications().contains(relation));
    }

    @Test
    @DisabledIf(value="testApiOnly")
    public void testReplaceDirectPlaceholders() {
        Object model = this.createEmptyModel();
        RelationProcessor processor = (RelationProcessor)this.createProcessor(model);
        T source = this.getUniqueNonPlaceholderSourceEntity();
        S destination = this.getUniqueNonPlaceholderDestinationEntity();
        R relation = this.createRelation(source, destination, false);
        R placeholder = this.createRelation(source, destination, true);
        processor.merge(placeholder);
        Assert.assertTrue((boolean)model.contains(placeholder));
        Assert.assertFalse((boolean)model.contains(relation));
        Assert.assertTrue((boolean)processor.getImplications().isEmpty());
        processor.replaceDirectPlaceholders(relation);
        Set implications = processor.getImplications();
        Assert.assertFalse((boolean)model.contains(placeholder));
        Assert.assertFalse((boolean)model.contains(relation));
        Assert.assertFalse((boolean)implications.contains(placeholder));
        Assert.assertFalse((boolean)implications.contains(relation));
    }

    @Test
    @DisabledIf(value="testApiOnly")
    public void testProcessReplacesDirectPlaceholder() {
        Object model = this.createEmptyModel();
        RelationProcessor processor = (RelationProcessor)this.createProcessor(model);
        T source = this.getUniqueNonPlaceholderSourceEntity();
        S destination = this.getUniqueNonPlaceholderDestinationEntity();
        R relation = this.createRelation(source, destination, false);
        R placeholder = this.createRelation(source, destination, true);
        processor.merge(placeholder);
        Assert.assertTrue((boolean)model.contains(placeholder));
        Assert.assertFalse((boolean)model.contains(relation));
        Assert.assertTrue((boolean)processor.getImplications().isEmpty());
        processor.process(relation);
        Set implications = processor.getImplications();
        Assert.assertFalse((boolean)model.contains(placeholder));
        Assert.assertTrue((boolean)model.contains(relation));
        Assert.assertFalse((boolean)implications.contains(placeholder));
        Assert.assertFalse((boolean)implications.contains(relation));
    }

    @Test
    @DisabledIf(value="testApiOnly")
    public void testReplaceIndirectPlaceholdersSameSource() {
        Object model = this.createEmptyModel();
        RelationProcessor processor = (RelationProcessor)this.createProcessor(model);
        T source = this.getUniqueNonPlaceholderSourceEntity();
        S destination = this.getUniqueNonPlaceholderDestinationEntity();
        S destinationPlaceholder = this.getPlaceholderOfDestinationEntity(destination);
        R relation = this.createRelation(source, destination, true);
        R placeholder = this.createRelation(source, destinationPlaceholder, true);
        processor.merge(placeholder);
        model.add(source);
        model.add(destinationPlaceholder);
        Assert.assertTrue((boolean)model.contains(placeholder));
        Assert.assertTrue((boolean)model.contains(source));
        Assert.assertTrue((boolean)model.contains(destinationPlaceholder));
        Assert.assertFalse((boolean)model.contains(destination));
        Assert.assertFalse((boolean)model.contains(relation));
        Assert.assertTrue((boolean)processor.getImplications().isEmpty());
        processor.replaceIndirectPlaceholders(relation);
        Set implications = processor.getImplications();
        Assert.assertFalse((boolean)model.contains(placeholder));
        Assert.assertTrue((boolean)model.contains(source));
        Assert.assertFalse((boolean)model.contains(destinationPlaceholder));
        Assert.assertFalse((boolean)model.contains(destination));
        Assert.assertFalse((boolean)model.contains(relation));
        Assert.assertFalse((boolean)implications.contains(placeholder));
        Assert.assertFalse((boolean)implications.contains(source));
        Assert.assertFalse((boolean)implications.contains(destinationPlaceholder));
        Assert.assertTrue((boolean)implications.contains(destination));
        Assert.assertFalse((boolean)implications.contains(relation));
    }

    @Test
    @DisabledIf(value="testApiOnly")
    public void testReplaceIndirectPlaceholdersSameDestination() {
        Object model = this.createEmptyModel();
        RelationProcessor processor = (RelationProcessor)this.createProcessor(model);
        T source = this.getUniqueNonPlaceholderSourceEntity();
        T sourcePlaceholder = this.getPlaceholderOfSourceEntity(source);
        S destination = this.getUniqueNonPlaceholderDestinationEntity();
        R relation = this.createRelation(source, destination, true);
        R placeholder = this.createRelation(sourcePlaceholder, destination, true);
        processor.merge(placeholder);
        model.add(sourcePlaceholder);
        model.add(destination);
        Assert.assertTrue((boolean)model.contains(placeholder));
        Assert.assertTrue((boolean)model.contains(sourcePlaceholder));
        Assert.assertTrue((boolean)model.contains(destination));
        Assert.assertFalse((boolean)model.contains(source));
        Assert.assertFalse((boolean)model.contains(relation));
        Assert.assertTrue((boolean)processor.getImplications().isEmpty());
        processor.replaceIndirectPlaceholders(relation);
        Set implications = processor.getImplications();
        Assert.assertFalse((boolean)model.contains(placeholder));
        Assert.assertFalse((boolean)model.contains(sourcePlaceholder));
        Assert.assertTrue((boolean)model.contains(destination));
        Assert.assertFalse((boolean)model.contains(source));
        Assert.assertFalse((boolean)model.contains(relation));
        Assert.assertFalse((boolean)implications.contains(placeholder));
        Assert.assertFalse((boolean)implications.contains(sourcePlaceholder));
        Assert.assertFalse((boolean)implications.contains(destination));
        Assert.assertTrue((boolean)implications.contains(source));
        Assert.assertFalse((boolean)implications.contains(relation));
    }

    @Test
    @DisabledIf(value="testApiOnly")
    public void testProcessReplacesIndirectPlaceholder() {
        Object model = this.createEmptyModel();
        RelationProcessor processor = (RelationProcessor)this.createProcessor(model);
        T source = this.getUniqueNonPlaceholderSourceEntity();
        S destination = this.getUniqueNonPlaceholderDestinationEntity();
        S destinationPlaceholder = this.getPlaceholderOfDestinationEntity(destination);
        R relation = this.createRelation(source, destination, true);
        R placeholder = this.createRelation(source, destinationPlaceholder, true);
        processor.merge(placeholder);
        model.add(source);
        model.add(destinationPlaceholder);
        Assert.assertTrue((boolean)model.contains(placeholder));
        Assert.assertTrue((boolean)model.contains(source));
        Assert.assertTrue((boolean)model.contains(destinationPlaceholder));
        Assert.assertFalse((boolean)model.contains(destination));
        Assert.assertFalse((boolean)model.contains(relation));
        Assert.assertTrue((boolean)processor.getImplications().isEmpty());
        processor.process(relation);
        Set implications = processor.getImplications();
        Assert.assertFalse((boolean)model.contains(placeholder));
        Assert.assertTrue((boolean)model.contains(source));
        Assert.assertFalse((boolean)model.contains(destinationPlaceholder));
        Assert.assertFalse((boolean)model.contains(destination));
        Assert.assertTrue((boolean)model.contains(relation));
        Assert.assertFalse((boolean)implications.contains(placeholder));
        Assert.assertTrue((boolean)implications.contains(source));
        Assert.assertFalse((boolean)implications.contains(destinationPlaceholder));
        Assert.assertTrue((boolean)implications.contains(destination));
        Assert.assertFalse((boolean)implications.contains(relation));
    }

    @Test
    @DisabledIf(value="testApiOnly")
    public void testReplaceIndirectPlaceholdersNoReplaceSameSource() {
        Object model = this.createEmptyModel();
        RelationProcessor processor = (RelationProcessor)this.createProcessor(model);
        T source = this.getUniqueNonPlaceholderSourceEntity();
        S destination = this.getUniqueNonPlaceholderDestinationEntity();
        S otherDestination = this.getUniqueNonPlaceholderDestinationEntity();
        R relation = this.createRelation(source, destination, true);
        R otherRelation = this.createRelation(source, otherDestination, true);
        model.add(source);
        model.add(destination);
        model.add(otherDestination);
        model.add(otherRelation);
        processor.replaceIndirectPlaceholders(relation);
        Set implications = processor.getImplications();
        Assert.assertTrue((boolean)model.contains(source));
        Assert.assertTrue((boolean)model.contains(destination));
        Assert.assertTrue((boolean)model.contains(otherDestination));
        Assert.assertTrue((boolean)model.contains(otherRelation));
        Assert.assertFalse((boolean)model.contains(relation));
        Assert.assertFalse((boolean)implications.contains(source));
        Assert.assertFalse((boolean)implications.contains(destination));
        Assert.assertFalse((boolean)implications.contains(otherDestination));
        Assert.assertFalse((boolean)implications.contains(otherRelation));
        Assert.assertFalse((boolean)implications.contains(relation));
    }

    @Test
    @DisabledIf(value="testApiOnly")
    public void testReplaceIndirectPlaceholdersNoReplaceSameDestination() {
        Object model = this.createEmptyModel();
        RelationProcessor processor = (RelationProcessor)this.createProcessor(model);
        T source = this.getUniqueNonPlaceholderSourceEntity();
        T otherSource = this.getUniqueNonPlaceholderSourceEntity();
        S destination = this.getUniqueNonPlaceholderDestinationEntity();
        R relation = this.createRelation(source, destination, true);
        R otherRelation = this.createRelation(otherSource, destination, true);
        model.add(source);
        model.add(destination);
        model.add(otherSource);
        model.add(otherRelation);
        processor.replaceIndirectPlaceholders(relation);
        Set implications = processor.getImplications();
        Assert.assertTrue((boolean)model.contains(source));
        Assert.assertTrue((boolean)model.contains(destination));
        Assert.assertTrue((boolean)model.contains(otherSource));
        Assert.assertTrue((boolean)model.contains(otherRelation));
        Assert.assertFalse((boolean)model.contains(relation));
        Assert.assertFalse((boolean)implications.contains(source));
        Assert.assertFalse((boolean)implications.contains(destination));
        Assert.assertFalse((boolean)implications.contains(otherSource));
        Assert.assertFalse((boolean)implications.contains(otherRelation));
        Assert.assertFalse((boolean)implications.contains(relation));
    }

    @Override
    protected R createUniqueReplaceable() {
        T source = this.getUniqueNonPlaceholderSourceEntity();
        S destination = this.getUniqueNonPlaceholderDestinationEntity();
        return this.createRelation(source, destination, false);
    }

    protected abstract R createRelation(T var1, S var2, boolean var3);

    protected abstract T getUniqueNonPlaceholderSourceEntity();

    protected abstract T getPlaceholderOfSourceEntity(T var1);

    protected abstract S getUniqueNonPlaceholderDestinationEntity();

    protected abstract S getPlaceholderOfDestinationEntity(S var1);
}

