/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.surrogate;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.mdsd.mocore.framework.surrogate.Element;
import tools.mdsd.mocore.framework.surrogate.Replaceable;
import tools.mdsd.mocore.framework.surrogate.ReplaceableTest;

public abstract class ElementTest<T extends Element<S>, S>
extends ReplaceableTest<T> {
    @Test
    public void testIncludesUnequalReplaceable() {
        Element nonPlaceholder = (Element)this.getUniqueNonPlaceholder();
        Element placeholder = this.getPlaceholderOf((Element)this.getUniqueNonPlaceholder());
        Assertions.assertFalse((boolean)nonPlaceholder.includes((Replaceable)placeholder));
        Assertions.assertFalse((boolean)nonPlaceholder.includes(this.getUniqueNonPlaceholder()));
        Assertions.assertFalse((boolean)placeholder.includes((Replaceable)nonPlaceholder));
        Assertions.assertFalse((boolean)placeholder.includes((Replaceable)this.getPlaceholderOf((Element)this.getUniqueNonPlaceholder())));
    }

    @Test
    public void testGetValue() {
        S value = this.getUniqueValue();
        T nonPlaceholder = this.createElement(value, false);
        T placeholder = this.createElement(value, true);
        Assertions.assertEquals(value, (Object)nonPlaceholder.getValue());
        Assertions.assertEquals(value, (Object)placeholder.getValue());
    }

    protected abstract T createElement(S var1, boolean var2);

    protected abstract S getUniqueValue();
}

