/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.surrogate;

import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.mdsd.mocore.framework.surrogate.Model;
import tools.mdsd.mocore.framework.surrogate.Relation;
import tools.mdsd.mocore.framework.surrogate.Replaceable;

public abstract class ModelTest<T extends Model, S extends Replaceable> {
    @Test
    public void testAddAndContainsWithValidReplaceable() {
        T model = this.createEmptyModel();
        S replaceable = this.createUniqueReplaceable();
        Assertions.assertFalse((boolean)model.contains(replaceable));
        model.add(replaceable);
        Assertions.assertTrue((boolean)model.contains(replaceable));
    }

    @Test
    public void testAddDuplicates() {
        T model = this.createEmptyModel();
        S replaceable = this.createUniqueReplaceable();
        List replaceables = model.getByType(replaceable.getClass());
        Assert.assertEquals((long)0L, (long)replaceables.size());
        model.add(replaceable);
        model.add(replaceable);
        model.add(replaceable);
        replaceables = model.getByType(replaceable.getClass());
        Assert.assertEquals((long)1L, (long)replaceables.size());
    }

    @Test
    public void testAddNull() {
        Object model = this.createEmptyModel();
        Assertions.assertThrows(RuntimeException.class, () -> model.add(null));
    }

    @Test
    public void testContainsNull() {
        T model = this.createEmptyModel();
        Assertions.assertFalse((boolean)model.contains(null));
    }

    @Test
    public void testGetByTypeWithValidReplaceables() {
        T model = this.createEmptyModel();
        S replaceableFst = this.createUniqueReplaceable();
        S replaceableSnd = this.createUniqueReplaceable();
        S replaceableTrd = this.createUniqueReplaceable();
        model.add(replaceableFst);
        model.add(replaceableSnd);
        model.add(replaceableTrd);
        List replaceables = model.getByType(replaceableFst.getClass());
        Assert.assertEquals((long)3L, (long)replaceables.size());
        Assertions.assertTrue((boolean)replaceables.contains(replaceableFst));
        Assertions.assertTrue((boolean)replaceables.contains(replaceableSnd));
        Assertions.assertTrue((boolean)replaceables.contains(replaceableTrd));
    }

    @Test
    public void testReplaceEqualEntities() {
        T model = this.createEmptyModel();
        S replaceable = this.createUniqueReplaceable();
        model.add(replaceable);
        model.add(this.createUniqueReplaceable());
        Assertions.assertTrue((boolean)model.contains(replaceable));
        Assert.assertEquals((long)2L, (long)model.getByType(replaceable.getClass()).size());
        Set implications = model.replace(replaceable, replaceable);
        Assertions.assertFalse((boolean)model.contains(replaceable));
        Assert.assertEquals((long)1L, (long)model.getByType(replaceable.getClass()).size());
        Assertions.assertTrue((boolean)implications.contains(replaceable));
        Assert.assertEquals((long)1L, (long)implications.size());
    }

    @Test
    public void testReplaceUnknownOriginal() {
        T model = this.createEmptyModel();
        S replaceable = this.createUniqueReplaceable();
        model.add(replaceable);
        Assertions.assertTrue((boolean)model.contains(replaceable));
        Assert.assertEquals((long)1L, (long)model.getByType(replaceable.getClass()).size());
        Set implications = model.replace(this.createUniqueReplaceable(), replaceable);
        Assertions.assertTrue((boolean)model.contains(replaceable));
        Assert.assertEquals((long)1L, (long)model.getByType(replaceable.getClass()).size());
        Assertions.assertFalse((boolean)implications.contains(replaceable));
        Assert.assertEquals((long)0L, (long)implications.size());
    }

    @Test
    public void testReplaceElementWithinRelation() {
        T model = this.createEmptyModel();
        Object source = this.createUniqueReplaceable();
        S destination = this.createUniqueReplaceable();
        Object replacementDestination = this.createUniqueReplaceable();
        Relation relation = this.createRelation(source, destination, false);
        model.add(source);
        model.add(destination);
        model.add(relation);
        Assertions.assertTrue((boolean)model.contains(source));
        Assertions.assertTrue((boolean)model.contains(destination));
        Assertions.assertFalse((boolean)model.contains(replacementDestination));
        Assertions.assertTrue((boolean)model.contains(relation));
        Set implications = model.replace(destination, replacementDestination);
        Assertions.assertTrue((boolean)model.contains(source));
        Assertions.assertFalse((boolean)model.contains(destination));
        Assertions.assertFalse((boolean)model.contains(replacementDestination));
        Assertions.assertFalse((boolean)model.contains(relation));
        Assert.assertEquals((long)2L, (long)implications.size());
        Assertions.assertTrue((boolean)implications.contains(replacementDestination));
        Assertions.assertFalse((boolean)implications.contains(relation));
        implications.remove(replacementDestination);
        implications.forEach(implication -> {
            Assert.assertEquals(relation.getClass(), implication.getClass());
            Assert.assertEquals((Object)source, (Object)((Relation)implication).getSource());
            Assert.assertEquals((Object)replacementDestination, (Object)((Relation)implication).getDestination());
            Assert.assertEquals((Object)relation.isPlaceholder(), (Object)implication.isPlaceholder());
        });
    }

    @Test
    public void testReplacePlaceholderRelation() {
        T model = this.createEmptyModel();
        S source = this.createUniqueReplaceable();
        S destination = this.createUniqueReplaceable();
        Relation<S, S> placeholder = this.createRelation(source, destination, true);
        Relation<S, S> nonPlaceholder = this.createRelation(source, destination, false);
        model.add(source);
        model.add(destination);
        model.add(placeholder);
        Assertions.assertTrue((boolean)model.contains(source));
        Assertions.assertTrue((boolean)model.contains(destination));
        Assertions.assertTrue((boolean)model.contains(placeholder));
        Assertions.assertFalse((boolean)model.contains(nonPlaceholder));
        Set implications = model.replace(placeholder, nonPlaceholder);
        Assertions.assertTrue((boolean)model.contains(source));
        Assertions.assertTrue((boolean)model.contains(destination));
        Assertions.assertFalse((boolean)model.contains(placeholder));
        Assertions.assertFalse((boolean)model.contains(nonPlaceholder));
        Assert.assertEquals((long)1L, (long)implications.size());
        Assertions.assertTrue((boolean)implications.contains(nonPlaceholder));
    }

    @Test
    public void testReplaceNullOriginalOrReplacement() {
        Object model = this.createEmptyModel();
        Object replaceable = this.createUniqueReplaceable();
        model.add(replaceable);
        Assertions.assertThrows(RuntimeException.class, () -> {
            Set set = model.replace(null, replaceable);
        });
        Assertions.assertThrows(RuntimeException.class, () -> {
            Set set = model.replace(replaceable, null);
        });
        Assertions.assertThrows(RuntimeException.class, () -> {
            Set set = model.replace(null, null);
        });
    }

    protected abstract T createEmptyModel();

    protected abstract S createUniqueReplaceable();

    protected abstract Relation<S, S> createRelation(S var1, S var2, boolean var3);
}

