/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.surrogate;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.mdsd.mocore.framework.surrogate.Relation;
import tools.mdsd.mocore.framework.surrogate.Replaceable;
import tools.mdsd.mocore.framework.surrogate.ReplaceableTest;

public abstract class RelationTest<R extends Relation<T, S>, T extends Replaceable, S extends Replaceable>
extends ReplaceableTest<R> {
    @Test
    public void testGetSource() {
        T source = this.getUniqueSourceEntity();
        S destination = this.getUniqueDestinationEntity();
        R nonPlaceholder = this.createRelation(source, destination, false);
        R placeholder = this.createRelation(source, destination, true);
        Assertions.assertEquals(source, (Object)nonPlaceholder.getSource());
        Assertions.assertEquals(source, (Object)placeholder.getSource());
    }

    @Test
    public void testGetDestination() {
        T source = this.getUniqueSourceEntity();
        S destination = this.getUniqueDestinationEntity();
        R nonPlaceholder = this.createRelation(source, destination, false);
        R placeholder = this.createRelation(source, destination, true);
        Assertions.assertEquals(destination, (Object)nonPlaceholder.getDestination());
        Assertions.assertEquals(destination, (Object)placeholder.getDestination());
    }

    @Test
    public void testIncludesEqualSource() {
        T source = this.getUniqueSourceEntity();
        S destination = this.getUniqueDestinationEntity();
        R nonPlaceholder = this.createRelation(source, destination, false);
        R placeholder = this.createRelation(source, destination, true);
        Assertions.assertTrue((boolean)nonPlaceholder.includes(source));
        Assertions.assertTrue((boolean)placeholder.includes(source));
    }

    @Test
    public void testIncludesEqualDestination() {
        T source = this.getUniqueSourceEntity();
        S destination = this.getUniqueDestinationEntity();
        R nonPlaceholder = this.createRelation(source, destination, false);
        R placeholder = this.createRelation(source, destination, true);
        Assertions.assertTrue((boolean)nonPlaceholder.includes(destination));
        Assertions.assertTrue((boolean)placeholder.includes(destination));
    }

    @Test
    public void testReplaceSource() {
        T originalSource = this.getUniqueSourceEntity();
        T replacementSource = this.getUniqueSourceEntity();
        S destination = this.getUniqueDestinationEntity();
        R relation = this.createRelation(originalSource, destination, false);
        Relation replaceRelation = (Relation)relation.replace(originalSource, replacementSource);
        Assertions.assertEquals(replacementSource, (Object)replaceRelation.getSource());
        Assertions.assertEquals(destination, (Object)replaceRelation.getDestination());
    }

    @Test
    public void testReplaceDestination() {
        T source = this.getUniqueSourceEntity();
        S originalDestination = this.getUniqueDestinationEntity();
        S replacementDestination = this.getUniqueDestinationEntity();
        R relation = this.createRelation(source, originalDestination, false);
        Relation replaceRelation = (Relation)relation.replace(originalDestination, replacementDestination);
        Assertions.assertEquals(source, (Object)replaceRelation.getSource());
        Assertions.assertEquals(replacementDestination, (Object)replaceRelation.getDestination());
    }

    @Override
    protected R getUniqueNonPlaceholder() {
        return this.createRelation(this.getUniqueSourceEntity(), this.getUniqueDestinationEntity(), false);
    }

    @Override
    protected R getPlaceholderOf(R replaceable) {
        Replaceable source = replaceable.getSource();
        Replaceable destination = replaceable.getDestination();
        return this.createRelation(source, destination, true);
    }

    protected abstract R createRelation(T var1, S var2, boolean var3);

    protected abstract T getUniqueSourceEntity();

    protected abstract S getUniqueDestinationEntity();
}

