/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.surrogate;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.mdsd.mocore.framework.surrogate.Replaceable;
import tools.mdsd.mocore.utility.SimpleElement;

public abstract class ReplaceableTest<T extends Replaceable> {
    private static long nextUniqueValue;

    @Test
    public void testIsPlaceholderNonPlaceholder() {
        T entity = this.getUniqueNonPlaceholder();
        Assertions.assertFalse((boolean)entity.isPlaceholder());
    }

    @Test
    public void testIsPlaceholderWithPlaceholder() {
        T entity = this.getPlaceholderOf(this.getUniqueNonPlaceholder());
        Assertions.assertTrue((boolean)entity.isPlaceholder());
    }

    @Test
    public void testIncludesEqualReplaceable() {
        T nonPlaceholder = this.getUniqueNonPlaceholder();
        T placeholder = this.getPlaceholderOf(this.getUniqueNonPlaceholder());
        Assertions.assertTrue((boolean)nonPlaceholder.includes(nonPlaceholder));
        Assertions.assertTrue((boolean)placeholder.includes(placeholder));
    }

    @Test
    public void testIncludesNull() {
        T entity = this.getPlaceholderOf(this.getUniqueNonPlaceholder());
        Assertions.assertFalse((boolean)entity.includes(null));
    }

    @Test
    public void testReplaceNullOriginal() {
        Object original = this.getUniqueNonPlaceholder();
        Object replacement = this.getUniqueNonPlaceholder();
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Replaceable replaceable3 = original.replace(null, replacement);
        });
    }

    @Test
    public void testReplaceEqualOriginalEqualReplacement() {
        T original = this.getUniqueNonPlaceholder();
        Replaceable replaceResult = original.replace(original, original);
        Assertions.assertEquals(original, (Object)replaceResult);
    }

    @Test
    public void testReplaceEqualOriginalOtherReplacementSameType() {
        T replacement = this.getUniqueNonPlaceholder();
        T original = this.getPlaceholderOf(replacement);
        Replaceable replaceResult = original.replace(original, replacement);
        Assertions.assertEquals(replacement, (Object)replaceResult);
    }

    @Test
    public void testIsPlaceholderOfEqualNonPlaceholderReplaceable() {
        T entity = this.getUniqueNonPlaceholder();
        Assertions.assertFalse((boolean)entity.isPlaceholderOf(entity));
    }

    @Test
    public void testIsPlaceholderOfEqualPlaceholderReplaceable() {
        T entity = this.getPlaceholderOf(this.getUniqueNonPlaceholder());
        Assertions.assertFalse((boolean)entity.isPlaceholderOf(entity));
    }

    @Test
    public void testIsPlaceholderOfValidPlaceholderWrongDirection() {
        T replacement = this.getUniqueNonPlaceholder();
        T original = this.getPlaceholderOf(replacement);
        Assertions.assertFalse((boolean)replacement.isPlaceholderOf(original));
    }

    @Test
    public void testIsPlaceholderOfValidPlaceholder() {
        T replacement = this.getUniqueNonPlaceholder();
        T original = this.getPlaceholderOf(replacement);
        Assertions.assertTrue((boolean)original.isPlaceholderOf(replacement));
    }

    @Test
    public void testIsPlaceholderDifferentType() {
        T nonPlaceholder = this.getUniqueNonPlaceholder();
        T placeholder = this.getPlaceholderOf(nonPlaceholder);
        SimpleElement differentTypeReplaceable = new SimpleElement(false);
        Assertions.assertFalse((boolean)nonPlaceholder.isPlaceholderOf((Replaceable)differentTypeReplaceable));
        Assertions.assertFalse((boolean)placeholder.isPlaceholderOf((Replaceable)differentTypeReplaceable));
    }

    @Test
    public void testEqualsNull() {
        T entity = this.getUniqueNonPlaceholder();
        Assertions.assertFalse((boolean)entity.equals(null));
    }

    @Test
    public void testEqualsAndHashCodeSameReference() {
        T entity = this.getUniqueNonPlaceholder();
        Assertions.assertTrue((boolean)entity.equals(entity));
        Assertions.assertEquals((int)entity.hashCode(), (int)entity.hashCode());
    }

    @Test
    public void testEqualsAndHashCodeDifferentType() {
        T entity = this.getUniqueNonPlaceholder();
        SimpleElement differentTypeReplaceable = new SimpleElement(false);
        Assertions.assertFalse((boolean)entity.equals((Object)differentTypeReplaceable));
        Assertions.assertNotEquals((int)entity.hashCode(), (int)differentTypeReplaceable.hashCode());
    }

    @Test
    public void testEqualsAndHashCodeUnequalReplaceables() {
        T firstEntity = this.getUniqueNonPlaceholder();
        T secondEntity = this.getUniqueNonPlaceholder();
        T thirdEntity = this.getPlaceholderOf(this.getUniqueNonPlaceholder());
        T fourthEntity = this.getPlaceholderOf(this.getUniqueNonPlaceholder());
        Assertions.assertFalse((boolean)firstEntity.equals(secondEntity));
        Assertions.assertFalse((boolean)secondEntity.equals(firstEntity));
        Assertions.assertNotEquals((int)firstEntity.hashCode(), (int)secondEntity.hashCode());
        Assertions.assertFalse((boolean)firstEntity.equals(fourthEntity));
        Assertions.assertFalse((boolean)fourthEntity.equals(secondEntity));
        Assertions.assertNotEquals((int)firstEntity.hashCode(), (int)fourthEntity.hashCode());
        Assertions.assertNotEquals((int)secondEntity.hashCode(), (int)fourthEntity.hashCode());
        Assertions.assertFalse((boolean)thirdEntity.equals(fourthEntity));
        Assertions.assertFalse((boolean)fourthEntity.equals(thirdEntity));
        Assertions.assertNotEquals((int)thirdEntity.hashCode(), (int)fourthEntity.hashCode());
    }

    @Test
    public void testEqualsAndHashCodePlaceholderAndNonPlaceholder() {
        T nonPlaceholder = this.getUniqueNonPlaceholder();
        T placeholder = this.getPlaceholderOf(nonPlaceholder);
        Assertions.assertFalse((boolean)nonPlaceholder.equals(placeholder));
        Assertions.assertFalse((boolean)placeholder.equals(nonPlaceholder));
        Assertions.assertNotEquals((int)nonPlaceholder.hashCode(), (int)placeholder.hashCode());
    }

    protected abstract T getUniqueNonPlaceholder();

    protected abstract T getPlaceholderOf(T var1);

    protected static long getUniqueLongValue() {
        return nextUniqueValue++;
    }
}

