/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.surrogate;

import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.mdsd.mocore.framework.surrogate.TypedDistinctMultiMap;

public class TypedDistinctMultiMapTest {
    @Test
    public void testPutValidElements() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        String entityFst = "Test";
        String entitySnd = "Entity";
        map.put((Object)entityFst);
        map.put((Object)entitySnd);
        map.put((Object)1L);
        map.put((Object)Float.valueOf(2.0f));
        Assertions.assertTrue((boolean)map.containsElement((Object)entityFst));
        Assertions.assertTrue((boolean)map.containsElement((Object)entitySnd));
        Assertions.assertTrue((boolean)map.containsElement((Object)1L));
        Assertions.assertTrue((boolean)map.containsElement((Object)Float.valueOf(2.0f)));
    }

    @Test
    public void testPutAndGetDuplicates() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        String entity = "Test";
        map.put((Object)entity);
        map.put((Object)entity);
        map.put((Object)entity);
        List elements = map.get(String.class);
        Assertions.assertTrue((boolean)map.containsElement((Object)entity));
        Assert.assertEquals((long)1L, (long)elements.size());
    }

    @Test
    public void testPutNull() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        Assert.assertThrows(NullPointerException.class, () -> map.put(null));
    }

    @Test
    public void testGetExistingKey() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        String entityFst = "Test";
        String entitySnd = "Entity";
        map.put((Object)entityFst);
        map.put((Object)entitySnd);
        List elements = map.get(String.class);
        Assert.assertEquals((long)2L, (long)elements.size());
        Assertions.assertTrue((boolean)elements.contains(entityFst));
        Assertions.assertTrue((boolean)elements.contains(entitySnd));
    }

    @Test
    public void testGetUnkownKey() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        String entityFst = "Test";
        String entitySnd = "Entity";
        map.put((Object)entityFst);
        map.put((Object)entitySnd);
        List elements = map.get(Integer.class);
        Assert.assertEquals((long)0L, (long)elements.size());
    }

    @Test
    public void testGetChildKeys() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        String entityFst = "Test";
        String entitySnd = "Entity";
        map.put((Object)entityFst);
        map.put((Object)entitySnd);
        List elements = map.get(Object.class, false);
        Assert.assertEquals((long)2L, (long)elements.size());
    }

    @Test
    public void testGetIgnoreChildKeys() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        String entityFst = "Test";
        String entitySnd = "Entity";
        map.put((Object)entityFst);
        map.put((Object)entitySnd);
        List elements = map.get(Object.class, true);
        Assert.assertEquals((long)0L, (long)elements.size());
    }

    @Test
    public void testGetNull() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        Assert.assertThrows(NullPointerException.class, () -> {
            List list = map.get(null);
        });
    }

    @Test
    public void testRemoveExistingElement() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        String entity = "Test";
        map.put((Object)entity);
        Assertions.assertTrue((boolean)map.containsElement((Object)entity));
        map.remove((Object)entity);
        Assert.assertFalse((boolean)map.containsElement((Object)entity));
    }

    @Test
    public void testRemoveUnkownElement() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        String entity = "Test";
        map.put((Object)entity);
        Assertions.assertTrue((boolean)map.containsElement((Object)entity));
        Assertions.assertDoesNotThrow(() -> map.remove(new Object()));
        Assertions.assertDoesNotThrow(() -> map.remove(String.class));
        Assertions.assertTrue((boolean)map.containsElement((Object)entity));
    }

    @Test
    public void testRemoveNull() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        Assert.assertThrows(NullPointerException.class, () -> map.remove(null));
    }

    @Test
    public void testContainsKeyValidKey() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        String entity = "Test";
        map.put((Object)entity);
        Assertions.assertTrue((boolean)map.containsKey(String.class));
    }

    @Test
    public void testContainsKeyUnknownKey() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        String entity = "Test";
        map.put((Object)entity);
        Assert.assertFalse((boolean)map.containsKey(Object.class));
        Assert.assertFalse((boolean)map.containsKey(Integer.class));
    }

    @Test
    public void testContainsKeyNull() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        Assert.assertFalse((boolean)map.containsKey(null));
    }

    @Test
    public void testContainsElementValidElement() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        String entity = "Test";
        map.put((Object)entity);
        Assertions.assertTrue((boolean)map.containsElement((Object)entity));
    }

    @Test
    public void testContainsElementUnknownElement() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        String entity = "Test";
        map.put((Object)entity);
        Assert.assertFalse((boolean)map.containsElement(new Object()));
        Assert.assertFalse((boolean)map.containsElement(String.class));
        Assert.assertFalse((boolean)map.containsElement((Object)1L));
    }

    @Test
    public void testContainsElementNull() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        Assert.assertFalse((boolean)map.containsElement(null));
    }

    @Test
    public void testIteratorNotEmpty() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        String entity = "Test";
        map.put((Object)entity);
        map.put((Object)1L);
        map.put((Object)Float.valueOf(2.0f));
        Iterator iterator = map.iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        int elementCount = 0;
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (element.getClass() == String.class) {
                Assert.assertEquals((Object)entity, element);
                ++elementCount;
                continue;
            }
            if (element.getClass() == Long.class) {
                Assert.assertEquals((Object)1L, element);
                ++elementCount;
                continue;
            }
            if (element.getClass() == Float.class) {
                Assert.assertEquals((Object)Float.valueOf(2.0f), element);
                ++elementCount;
                continue;
            }
            Assertions.fail();
        }
        Assert.assertEquals((long)3L, (long)elementCount);
    }

    @Test
    public void testIteratorEmpty() {
        TypedDistinctMultiMap map = new TypedDistinctMultiMap();
        Iterator iterator = map.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

