/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.orchestration;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import tools.mdsd.mocore.framework.discovery.Discoverer;
import tools.mdsd.mocore.framework.orchestration.UnavailableProcessorException;
import tools.mdsd.mocore.framework.processor.Processor;
import tools.mdsd.mocore.framework.surrogate.Model;
import tools.mdsd.mocore.framework.surrogate.Replaceable;

public abstract class Orchestrator<M extends Model> {
    private final M model;
    private final Map<Class<?>, Processor<M, ?>> processorMap;

    protected Orchestrator(M model, Processor<M, ?> ... processors) {
        this.model = (Model)Objects.requireNonNull(model);
        this.processorMap = new HashMap();
        Processor<M, ?>[] processorArray = processors;
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            Processor<M, ?> processor = processorArray[n2];
            this.processorMap.put(processor.getProcessableType(), processor);
            ++n2;
        }
    }

    public M getModel() {
        return this.model;
    }

    public <T extends Replaceable> void processDiscoverer(Discoverer<T> discoverer) {
        for (Replaceable discovery : discoverer.getDiscoveries()) {
            this.processDiscovery(discovery);
        }
    }

    public <T extends Replaceable> void processDiscovery(T discovery) {
        Processor<M, T> processor = this.getProcessorForDiscovery(discovery).orElseThrow(() -> new UnavailableProcessorException(discovery.getClass()));
        if (!((Model)this.model).contains(discovery)) {
            processor.process(discovery);
            for (Replaceable implicitDiscovery : processor.getImplications()) {
                this.processDiscovery(implicitDiscovery);
            }
        }
    }

    protected <T extends Replaceable> Optional<Processor<M, T>> getProcessorForDiscovery(T discovery) {
        return Optional.ofNullable(this.processorMap.get(discovery.getClass()));
    }
}

