/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.processor;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import tools.mdsd.mocore.framework.surrogate.Model;
import tools.mdsd.mocore.framework.surrogate.Replaceable;

public abstract class Processor<M extends Model, T extends Replaceable> {
    private final M model;
    private final Set<Replaceable> implications;
    private final Class<T> processableType;

    protected Processor(M model, Class<T> processableType) {
        this.model = (Model)Objects.requireNonNull(model);
        this.implications = new HashSet<Replaceable>();
        this.processableType = Objects.requireNonNull(processableType);
    }

    public void process(T discovery) {
        this.implications.clear();
        this.merge(discovery);
        this.refine(discovery);
    }

    protected void merge(T discovery) {
        ((Model)this.model).add((Replaceable)discovery);
    }

    protected abstract void refine(T var1);

    public M getModel() {
        return this.model;
    }

    public Set<Replaceable> getImplications() {
        return Set.copyOf(this.implications);
    }

    protected void addImplication(Replaceable replaceable) {
        this.implications.add(replaceable);
    }

    protected void addImplications(Iterable<Replaceable> replaceables) {
        for (Replaceable replaceable : replaceables) {
            this.implications.add(replaceable);
        }
    }

    protected void removeImplication(Replaceable replaceable) {
        this.implications.remove(replaceable);
    }

    protected void removeImplications(Iterable<Replaceable> replaceables) {
        for (Replaceable replaceable : replaceables) {
            this.implications.remove(replaceable);
        }
    }

    protected void replaceImplications(Replaceable original, Replaceable replacement) {
        HashSet<Replaceable> predecessors = new HashSet<Replaceable>();
        HashSet<Replaceable> successors = new HashSet<Replaceable>();
        for (Replaceable implication : this.implications) {
            if (!implication.includes(original)) continue;
            Replaceable successor = implication.replace(original, replacement);
            predecessors.add(implication);
            successors.add(successor);
        }
        this.implications.removeAll(predecessors);
        this.implications.addAll(successors);
    }

    public Class<T> getProcessableType() {
        return this.processableType;
    }
}

