/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.processor;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import tools.mdsd.mocore.framework.processor.Processor;
import tools.mdsd.mocore.framework.surrogate.Model;
import tools.mdsd.mocore.framework.surrogate.Relation;
import tools.mdsd.mocore.framework.surrogate.Replaceable;

public abstract class RelationProcessor<M extends Model, T extends Relation<?, ?>>
extends Processor<M, T> {
    protected RelationProcessor(M model, Class<T> processableType) {
        super(model, processableType);
    }

    @Override
    protected void refine(T discovery) {
        this.addImplication((Replaceable)((Relation)discovery).getSource());
        this.addImplication((Replaceable)((Relation)discovery).getDestination());
        this.replaceDirectPlaceholders(discovery);
        this.replaceIndirectPlaceholders(discovery);
    }

    protected void replaceDirectPlaceholders(T discovery) {
        List relations = ((Model)this.getModel()).getByType(this.getProcessableType());
        relations.removeIf(relation2 -> !relation2.isPlaceholderOf((Replaceable)discovery) && !discovery.isPlaceholderOf((Replaceable)relation2));
        HashSet<Replaceable> implications = new HashSet<Replaceable>();
        for (Relation relation : relations) {
            if (relation.isPlaceholderOf((Replaceable)discovery)) {
                implications.addAll(((Model)this.getModel()).replace(relation, (Replaceable)discovery));
                this.replaceImplications(relation, (Replaceable)discovery);
                continue;
            }
            if (!((Relation)discovery).isPlaceholderOf(relation)) continue;
            implications.addAll(((Model)this.getModel()).replace((Replaceable)discovery, relation));
            this.replaceImplications((Replaceable)discovery, relation);
        }
        implications.remove(discovery);
        this.addImplications(implications);
    }

    protected void replaceIndirectPlaceholders(T discovery) {
        Set relations = ((Model)this.getModel()).getByType(this.getProcessableType()).stream().filter(relation2 -> !Objects.equals(relation2, discovery)).filter(relation2 -> !relation2.isPlaceholderOf((Replaceable)discovery)).filter(relation2 -> !discovery.isPlaceholderOf((Replaceable)relation2)).filter(relation2 -> ((Replaceable)discovery.getSource()).equals(relation2.getSource()) || ((Replaceable)discovery.getDestination()).equals(relation2.getDestination())).collect(Collectors.toSet());
        HashSet<Replaceable> implications = new HashSet<Replaceable>();
        for (Relation relation : relations) {
            if (Objects.equals(((Relation)discovery).getSource(), relation.getSource())) {
                if (((Replaceable)relation.getDestination()).isPlaceholder()) {
                    if (!((Replaceable)discovery).isPlaceholder()) {
                        implications.addAll(((Model)this.getModel()).replace(relation, (Replaceable)discovery));
                    }
                    implications.addAll(((Model)this.getModel()).replace((Replaceable)relation.getDestination(), (Replaceable)((Relation)discovery).getDestination()));
                    continue;
                }
                if (!((Replaceable)((Relation)discovery).getDestination()).isPlaceholder()) continue;
                implications.addAll(((Model)this.getModel()).replace((Replaceable)((Relation)discovery).getDestination(), (Replaceable)relation.getDestination()));
                this.removeImplication((Replaceable)((Relation)discovery).getDestination());
                continue;
            }
            if (!Objects.equals(((Relation)discovery).getDestination(), relation.getDestination())) continue;
            if (((Replaceable)relation.getSource()).isPlaceholder()) {
                if (!((Replaceable)discovery).isPlaceholder()) {
                    implications.addAll(((Model)this.getModel()).replace(relation, (Replaceable)discovery));
                }
                implications.addAll(((Model)this.getModel()).replace((Replaceable)relation.getSource(), (Replaceable)((Relation)discovery).getSource()));
                continue;
            }
            if (!((Replaceable)((Relation)discovery).getSource()).isPlaceholder()) continue;
            implications.addAll(((Model)this.getModel()).replace((Replaceable)((Relation)discovery).getSource(), (Replaceable)relation.getSource()));
            this.removeImplication((Replaceable)((Relation)discovery).getSource());
        }
        implications.remove(discovery);
        this.addImplications(implications);
    }
}

