/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.surrogate;

import java.util.Objects;
import tools.mdsd.mocore.framework.surrogate.Replaceable;

public abstract class Element<T>
extends Replaceable {
    private static long nextUniqueValue;
    private final T value;

    protected Element(T value, boolean isPlaceholder) {
        super(isPlaceholder);
        this.value = Objects.requireNonNull(value);
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public boolean includes(Replaceable replaceable) {
        return this.equals(replaceable);
    }

    public <U extends Replaceable> U replace(U original, U replacement) {
        if (!this.includes(original)) {
            throw new IllegalArgumentException();
        }
        return replacement;
    }

    @Override
    public boolean isPlaceholderOf(Replaceable replaceable) {
        if (!this.isPlaceholder() || replaceable.isPlaceholder()) {
            return false;
        }
        if (this.getClass() != replaceable.getClass()) {
            return false;
        }
        Element element = (Element)replaceable;
        return Objects.equals(this.value, element.value);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Element element = (Element)object;
        return Objects.equals(this.value, element.value);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.value);
        return result;
    }

    protected static long getUniqueValue() {
        return nextUniqueValue++;
    }
}

