/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.surrogate;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import tools.mdsd.mocore.framework.surrogate.Replaceable;
import tools.mdsd.mocore.framework.surrogate.TypedDistinctMultiMap;

public class Model {
    private final TypedDistinctMultiMap<Replaceable> replaceables = new TypedDistinctMultiMap();

    public <T extends Replaceable> List<T> getByType(Class<T> type) {
        return this.replaceables.get(type);
    }

    public void add(Replaceable replaceable) {
        this.replaceables.put(replaceable);
    }

    public boolean contains(Replaceable replaceable) {
        return this.replaceables.containsElement(replaceable);
    }

    public Set<Replaceable> replace(Replaceable original, Replaceable replacement) {
        if (Objects.isNull(original) || Objects.isNull(replacement)) {
            throw new NullPointerException();
        }
        HashSet<Replaceable> implications = new HashSet<Replaceable>();
        for (Replaceable predecessor : this.replaceables) {
            if (!predecessor.includes(original)) continue;
            Replaceable successor = predecessor.replace(original, replacement);
            this.replaceables.remove(predecessor);
            implications.add(successor);
        }
        return implications;
    }
}

