/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.surrogate;

import java.util.Objects;
import tools.mdsd.mocore.framework.surrogate.Replaceable;

public abstract class Relation<T extends Replaceable, S extends Replaceable>
extends Replaceable {
    private final T source;
    private final S destination;

    protected Relation(T source, S destination, boolean isPlaceholder) {
        super(isPlaceholder);
        this.source = (Replaceable)Objects.requireNonNull(source);
        this.destination = (Replaceable)Objects.requireNonNull(destination);
    }

    public T getSource() {
        return this.source;
    }

    public S getDestination() {
        return this.destination;
    }

    @Override
    public boolean includes(Replaceable replaceable) {
        return this.equals(replaceable) || ((Replaceable)this.source).includes(replaceable) || ((Replaceable)this.destination).includes(replaceable);
    }

    protected <U extends Replaceable> T getSourceReplacement(U original, U replacement) {
        if (((Replaceable)this.source).includes(original)) {
            return (T)this.source.replace(original, replacement);
        }
        return this.source;
    }

    protected <U extends Replaceable> S getDestinationReplacement(U original, U replacement) {
        if (((Replaceable)this.destination).includes(original)) {
            return (S)((Replaceable)this.destination).replace(original, replacement);
        }
        return this.destination;
    }

    @Override
    public boolean isPlaceholderOf(Replaceable replaceable) {
        if (!this.isPlaceholder() || replaceable.isPlaceholder()) {
            return false;
        }
        if (this.getClass() != replaceable.getClass()) {
            return false;
        }
        Relation relation = (Relation)replaceable;
        return Objects.equals(this.destination, relation.destination) && Objects.equals(this.source, relation.source);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Relation relation = (Relation)object;
        return Objects.equals(this.destination, relation.destination) && Objects.equals(this.source, relation.source);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.destination, this.source);
        return result;
    }
}

